/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

class TextComponentEmptyText
extends StatusText {
    private final JTextComponent myOwner;
    private String myStatusTriggerText = "";

    TextComponentEmptyText(JTextComponent owner) {
        super(owner);
        this.myOwner = owner;
        this.clear();
        this.myOwner.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextComponentEmptyText.this.myOwner.repaint();
            }
        });
    }

    public void setTextToTriggerStatus(@NotNull String defaultText) {
        if (defaultText == null) {
            TextComponentEmptyText.$$$reportNull$$$0(0);
        }
        this.myStatusTriggerText = defaultText;
    }

    @NotNull
    public String getStatusTriggerText() {
        String string = this.myStatusTriggerText;
        if (string == null) {
            TextComponentEmptyText.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void paintStatusText(Graphics g) {
        if (!this.isFontSet()) {
            this.setFont(this.myOwner.getFont());
        }
        this.paint(this.myOwner, g);
    }

    @Override
    protected boolean isStatusVisible() {
        return this.myOwner.getText().equals(this.myStatusTriggerText) && !this.myOwner.isFocusOwner();
    }

    @Override
    protected Rectangle getTextComponentBound() {
        Rectangle b = this.myOwner.getBounds();
        Insets insets = (Insets)ObjectUtils.notNull((Object)this.myOwner.getInsets(), (Object)JBUI.emptyInsets());
        Insets margin = (Insets)ObjectUtils.notNull((Object)this.myOwner.getMargin(), (Object)JBUI.emptyInsets());
        Insets ipad = this.getComponent().getIpad();
        int left = insets.left + margin.left - ipad.left;
        int right = insets.right + margin.right - ipad.right;
        int top = insets.top + margin.top - ipad.top;
        int bottom = insets.bottom + margin.bottom - ipad.bottom;
        return new Rectangle(left, top, b.width - left - right, b.height - top - bottom);
    }

    @Override
    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        if (component == null) {
            TextComponentEmptyText.$$$reportNull$$$0(2);
        }
        if (bounds == null) {
            TextComponentEmptyText.$$$reportNull$$$0(3);
        }
        Dimension size = component.getPreferredSize();
        return component == this.getComponent() ? new Rectangle(bounds.x, bounds.y, size.width, bounds.height) : new Rectangle(bounds.x + bounds.width - size.width, bounds.y, size.width, bounds.height);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/TextComponentEmptyText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/TextComponentEmptyText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusTriggerText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTextToTriggerStatus";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustComponentBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

