/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.personalization.impl;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.stats.personalization.FactorReader;
import com.intellij.stats.personalization.impl.DailyAggregatedDoubleFactor;
import com.intellij.stats.personalization.impl.DailyAggregatedDoubleFactorKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/stats/personalization/impl/CompletionTypeReader;", "Lcom/intellij/stats/personalization/FactorReader;", "factor", "Lcom/intellij/stats/personalization/impl/DailyAggregatedDoubleFactor;", "(Lcom/intellij/stats/personalization/impl/DailyAggregatedDoubleFactor;)V", "getCompletionCountByType", "", "type", "Lcom/intellij/codeInsight/completion/CompletionType;", "getTotalCompletionCount", "intellij.statsCollector"})
public final class CompletionTypeReader
implements FactorReader {
    private final DailyAggregatedDoubleFactor factor;

    public final double getCompletionCountByType(@NotNull CompletionType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return ((Number)DailyAggregatedDoubleFactorKt.aggregateSum(this.factor).getOrDefault(type.toString(), 0.0)).doubleValue();
    }

    public final double getTotalCompletionCount() {
        return CollectionsKt.sumOfDouble((Iterable)DailyAggregatedDoubleFactorKt.aggregateSum(this.factor).values());
    }

    public CompletionTypeReader(@NotNull DailyAggregatedDoubleFactor factor) {
        Intrinsics.checkParameterIsNotNull((Object)factor, (String)"factor");
        this.factor = factor;
    }
}

