/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Collection;

public abstract class ChangeListTodosPanel
extends TodoPanel {
    private final Alarm myAlarm;

    public ChangeListTodosPanel(Project project, TodoPanelSettings settings, Content content2) {
        super(project, settings, false, content2);
        ChangeListManager.getInstance((Project)project).addChangeListListener((ChangeListListener)new MyChangeListManagerListener(), (Disposable)this);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    private final class MyChangeListManagerListener
    extends ChangeListAdapter {
        private MyChangeListManagerListener() {
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
            AppUIUtil.invokeOnEdt(() -> ChangeListTodosPanel.this.setDisplayName(TodoView.getTabNameForChangeList((String)newDefaultList.getName())));
        }

        public void changeListRenamed(ChangeList list, String oldName) {
            AppUIUtil.invokeOnEdt(() -> ChangeListTodosPanel.this.setDisplayName(TodoView.getTabNameForChangeList((String)list.getName())));
        }

        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
        }
    }
}

