/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsShelveUtils {
    private static final Logger LOG = Logger.getInstance((String)VcsShelveUtils.class.getName());

    public static void doSystemUnshelve(Project project, ShelvedChangeList shelvedChangeList, @Nullable LocalChangeList targetChangeList, ShelveChangesManager shelveManager, @Nullable String leftConflictTitle, @Nullable String rightConflictTitle) {
        VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        String projectPath = baseDir.getPath() + "/";
        shelvedChangeList.loadChangesIfNeeded(project);
        List<ShelvedChange> changes = Objects.requireNonNull(shelvedChangeList.getChanges());
        List<ShelvedBinaryFile> binaryFiles = shelvedChangeList.getBinaryFiles();
        LOG.info("refreshing files ");
        VcsShelveUtils.refreshFilesBeforeUnshelve(projectPath, changes, binaryFiles);
        LOG.info("Unshelving shelvedChangeList: " + shelvedChangeList);
        shelveManager.unshelveChangeList(shelvedChangeList, changes, binaryFiles, targetChangeList, false, true, true, leftConflictTitle, rightConflictTitle, true);
        ApplicationManager.getApplication().invokeAndWait(() -> VcsShelveUtils.markUnshelvedFilesNonUndoable(project, changes));
    }

    private static void markUnshelvedFilesNonUndoable(@NotNull Project project, @NotNull List<? extends ShelvedChange> changes) {
        UndoManagerImpl undoManager;
        if (project == null) {
            VcsShelveUtils.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            VcsShelveUtils.$$$reportNull$$$0(1);
        }
        if ((undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)project)) != null && !changes.isEmpty()) {
            ContainerUtil.process(changes, change -> {
                VirtualFile vfUnderProject = VfsUtil.findFileByIoFile((File)new File(project.getBasePath(), change.getAfterPath()), (boolean)false);
                if (vfUnderProject != null) {
                    DocumentReference documentReference = DocumentReferenceManager.getInstance().create(vfUnderProject);
                    undoManager.nonundoableActionPerformed(documentReference, false);
                    undoManager.invalidateActionsFor(documentReference);
                }
                return true;
            });
        }
    }

    private static void refreshFilesBeforeUnshelve(String projectPath, @NotNull List<? extends ShelvedChange> shelvedChanges, @NotNull List<? extends ShelvedBinaryFile> binaryFiles) {
        if (shelvedChanges == null) {
            VcsShelveUtils.$$$reportNull$$$0(2);
        }
        if (binaryFiles == null) {
            VcsShelveUtils.$$$reportNull$$$0(3);
        }
        HashSet filesToRefresh = new HashSet();
        shelvedChanges.forEach(c -> {
            if (c.getBeforePath() != null) {
                filesToRefresh.add(new File(projectPath + c.getBeforePath()));
            }
            if (c.getAfterPath() != null) {
                filesToRefresh.add(new File(projectPath + c.getAfterPath()));
            }
        });
        binaryFiles.forEach(f -> {
            if (f.BEFORE_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.BEFORE_PATH));
            }
            if (f.AFTER_PATH != null) {
                filesToRefresh.add(new File(projectPath + f.AFTER_PATH));
            }
        });
        LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
    }

    @Nullable
    public static ShelvedChangeList shelveChanges(Project project, ShelveChangesManager shelveManager, Collection<? extends Change> changes, String description, List<? super VcsException> exceptions, boolean rollback, boolean markToBeDeleted) {
        try {
            ShelvedChangeList shelve = shelveManager.shelveChanges(changes, description, rollback, markToBeDeleted);
            ((ChangeListener)BackgroundTaskUtil.syncPublisher((Project)project, ShelveChangesManager.SHELF_TOPIC)).stateChanged(new ChangeEvent(VcsShelveUtils.class));
            return shelve;
        }
        catch (IOException e) {
            exceptions.add(new VcsException("Shelving changes failed: " + description, (Throwable)e));
            return null;
        }
        catch (VcsException e) {
            exceptions.add(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsShelveUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markUnshelvedFilesNonUndoable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshFilesBeforeUnshelve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

