/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPanel
extends CommitDetailsPanel {
    @NotNull
    final VcsLogData myLogData;
    @NotNull
    final VcsLogColorManager myColorManager;
    @Nullable
    CommitId myCommit;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull Consumer<? super CommitId> navigate) {
        if (logData == null) {
            CommitPanel.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            CommitPanel.$$$reportNull$$$0(1);
        }
        if (navigate == null) {
            CommitPanel.$$$reportNull$$$0(2);
        }
        super(logData.getProject(), (Function1<? super CommitId, Unit>)((Function1)commitId -> {
            navigate.consume(commitId);
            return Unit.INSTANCE;
        }));
        this.myLogData = logData;
        this.myColorManager = colorManager;
    }

    @Override
    public void setCommit(@NotNull CommitId commit, @NotNull CommitPresentationUtil.CommitPresentation presentation) {
        if (commit == null) {
            CommitPanel.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            CommitPanel.$$$reportNull$$$0(4);
        }
        this.myCommit = commit;
        super.setCommit(commit, presentation);
        this.setBranches(this.myLogData.getContainingBranchesGetter().requestContainingBranches(commit.getRoot(), commit.getHash()));
        VirtualFile root = commit.getRoot();
        if (this.myColorManager.hasMultiplePaths()) {
            this.setRoot(new CommitDetailsPanel.RootColor(root, (Color)VcsLogGraphTable.getRootBackgroundColor(root, this.myColorManager)));
        } else {
            this.setRoot(null);
        }
    }

    public void setRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            CommitPanel.$$$reportNull$$$0(5);
        }
        this.setRefs(this.sortRefs(refs));
    }

    @NotNull
    protected List<? extends VcsRef> sortRefs(@NotNull Collection<? extends VcsRef> refs) {
        VcsRef ref;
        if (refs == null) {
            CommitPanel.$$$reportNull$$$0(6);
        }
        if ((ref = (VcsRef)ContainerUtil.getFirstItem(refs)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CommitPanel.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.sorted(refs, (Comparator)this.myLogData.getLogProvider(ref.getRoot()).getReferenceManager().getLabelsOrderComparator());
        if (list == null) {
            CommitPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            ContainingBranchesGetter getter = this.myLogData.getContainingBranchesGetter();
            this.setBranches(getter.getContainingBranchesFromCache(this.myCommit.getRoot(), this.myCommit.getHash()));
        } else {
            this.setBranches(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sortRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCommit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRefs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortRefs";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

