/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReadEnv;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final long DEFAULT_SHELL_ENV_READING_TIMEOUT_MILLIS = 20000L;
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    public static final String BASH_EXECUTABLE_NAME = "bash";
    public static final String SHELL_VARIABLE_NAME = "SHELL";
    private static final String SHELL_INTERACTIVE_ARGUMENT = "-i";
    private static final String SHELL_LOGIN_ARGUMENT = "-l";
    public static final String SHELL_COMMAND_ARGUMENT = "-c";
    private static final AtomicReference<CompletableFuture<Map<String, String>>> ourEnvGetter = new AtomicReference();
    private static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    private static final String INTELLIJ_ENVIRONMENT_READER = "INTELLIJ_ENVIRONMENT_READER";

    @NotNull
    private static Map<String, String> getSystemEnv() {
        if (SystemInfoRt.isWindows) {
            Map<String, String> map = Collections.unmodifiableMap(new THashMap(System.getenv(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
            if (map == null) {
                EnvironmentUtil.$$$reportNull$$$0(0);
            }
            return map;
        }
        Map<String, String> map = System.getenv();
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    private EnvironmentUtil() {
    }

    @ApiStatus.Internal
    public static void loadEnvironment(@NotNull Runnable callback) {
        if (callback == null) {
            EnvironmentUtil.$$$reportNull$$$0(2);
        }
        if (SystemInfoRt.isMac) {
            ourEnvGetter.set(CompletableFuture.supplyAsync(() -> {
                try {
                    Map<String, String> env = EnvironmentUtil.getShellEnv();
                    EnvironmentUtil.setCharsetVar(env);
                    Map<String, String> map = Collections.unmodifiableMap(env);
                    return map;
                }
                catch (Throwable t) {
                    LOG.warn("can't get shell environment", t);
                    Map<String, String> map = EnvironmentUtil.getSystemEnv();
                    return map;
                }
                finally {
                    callback.run();
                }
            }, AppExecutorUtil.getAppExecutorService()));
        } else {
            ourEnvGetter.set(CompletableFuture.completedFuture(EnvironmentUtil.getSystemEnv()));
            callback.run();
        }
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map;
        CompletableFuture<Map<String, String>> getter = ourEnvGetter.get();
        if (getter == null && !ourEnvGetter.compareAndSet(null, getter = CompletableFuture.completedFuture(EnvironmentUtil.getSystemEnv()))) {
            getter = ourEnvGetter.get();
        }
        try {
            map = getter.join();
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Nullable
    public static String getValue(@NonNls @NotNull String name) {
        if (name == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    public static String @NotNull [] getEnvironment() {
        return EnvironmentUtil.flattenEnvironment(EnvironmentUtil.getEnvironmentMap());
    }

    public static String @NotNull [] flattenEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        String[] array = new String[environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            array[i++] = entry.getKey() + "=" + entry.getValue();
        }
        if (array == null) {
            EnvironmentUtil.$$$reportNull$$$0(6);
        }
        return array;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty() && name.indexOf(0) == -1 && name.indexOf(61, SystemInfoRt.isWindows ? 1 : 0) == -1;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.indexOf(0) == -1;
    }

    @NotNull
    private static Map<String, String> getShellEnv() throws IOException {
        Map<String, String> map = new ShellEnvReader().readShellEnv(null);
        if (map == null) {
            EnvironmentUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<String> buildShellProcessCommand(@NotNull String shellScript, boolean isLogin, boolean isInteractive, boolean isCommand) {
        if (shellScript == null) {
            EnvironmentUtil.$$$reportNull$$$0(8);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(shellScript);
        if (isLogin && !shellScript.endsWith("/tcsh") && !shellScript.endsWith("/csh")) {
            commands.add(SHELL_LOGIN_ARGUMENT);
        }
        if (isInteractive && !shellScript.endsWith("/fish")) {
            commands.add(SHELL_INTERACTIVE_ARGUMENT);
        }
        if (isCommand) {
            commands.add(SHELL_COMMAND_ARGUMENT);
        }
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            EnvironmentUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, String> parseEnv(String @NotNull [] lines) {
        if (lines == null) {
            EnvironmentUtil.$$$reportNull$$$0(10);
        }
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL", DISABLE_OMZ_AUTO_UPDATE, INTELLIJ_ENVIRONMENT_READER));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new RuntimeException("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            EnvironmentUtil.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, String> parseEnv(@NotNull String text) {
        if (text == null) {
            EnvironmentUtil.$$$reportNull$$$0(12);
        }
        return EnvironmentUtil.parseEnv(text.split("\u0000"));
    }

    private static int waitAndTerminateAfter(@NotNull Process process, long timeoutMillis) {
        Integer exitCode;
        if (process == null) {
            EnvironmentUtil.$$$reportNull$$$0(13);
        }
        if ((exitCode = EnvironmentUtil.waitFor(process, timeoutMillis)) != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        if (!SystemInfoRt.isWindows) {
            UnixProcessManager.sendSigIntToProcessTree(process);
            exitCode = EnvironmentUtil.waitFor(process, 1000L);
            if (exitCode != null) {
                return exitCode;
            }
            LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        }
        if (SystemInfoRt.isWindows) {
            WinProcessManager.kill(process, true);
        } else {
            UnixProcessManager.sendSigKillToProcessTree(process);
        }
        exitCode = EnvironmentUtil.waitFor(process, 1000L);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process, long timeoutMillis) {
        if (process == null) {
            EnvironmentUtil.$$$reportNull$$$0(14);
        }
        try {
            if (process.waitFor(timeoutMillis, TimeUnit.MILLISECONDS)) {
                return process.exitValue();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for process", e);
        }
        return null;
    }

    private static void setCharsetVar(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(15);
        }
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            String value = EnvironmentUtil.setLocaleEnv(env, CharsetToolkit.getDefaultSystemCharset());
            LOG.info("LC_CTYPE=" + value);
        }
    }

    private static boolean checkIfLocaleAvailable(String candidateLanguageTerritory) {
        Locale[] available;
        for (Locale l : available = Locale.getAvailableLocales()) {
            if (!StringUtilRt.equal(l.toString(), candidateLanguageTerritory, true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        String languageTerritoryFromLocale;
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(16);
        }
        if (charset == null) {
            EnvironmentUtil.$$$reportNull$$$0(17);
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String languageTerritory = "en_US";
        if (!language.isEmpty() && !country.isEmpty() && EnvironmentUtil.checkIfLocaleAvailable(languageTerritoryFromLocale = language + '_' + country)) {
            languageTerritory = languageTerritoryFromLocale;
        }
        String result = languageTerritory + '.' + charset.name();
        env.put(LC_CTYPE, result);
        String string = result;
        if (string == null) {
            EnvironmentUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(19);
        }
        return !env.isEmpty() && (env.containsKey(LANG) || env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE));
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(20);
        }
        EnvironmentUtil.inlineParentOccurrences(envs, EnvironmentUtil.getEnvironmentMap());
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs, @NotNull Map<String, String> parentEnv) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(21);
        }
        if (parentEnv == null) {
            EnvironmentUtil.$$$reportNull$$$0(22);
        }
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = parentEnv.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    private static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    static Map<String, String> testLoader() {
        try {
            return EnvironmentUtil.getShellEnv();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, String> testParser(@NotNull String lines) {
        if (lines == null) {
            EnvironmentUtil.$$$reportNull$$$0(23);
        }
        try {
            return EnvironmentUtil.parseEnv(lines);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellScript";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemEnv";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellEnv";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildShellProcessCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "flattenEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildShellProcessCommand";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StreamGobbler
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean splitToLines() {
                return false;
            }
        };
        private final StringBuffer myBuffer;

        StreamGobbler(@NotNull InputStream stream) {
            if (stream == null) {
                StreamGobbler.$$$reportNull$$$0(0);
            }
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myBuffer = new StringBuffer();
            this.start("stdout/stderr streams of shell env loading process");
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                StreamGobbler.$$$reportNull$$$0(1);
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(runnable);
            if (future == null) {
                StreamGobbler.$$$reportNull$$$0(2);
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                StreamGobbler.$$$reportNull$$$0(3);
            }
            this.myBuffer.append(text);
        }

        @NotNull
        public String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                StreamGobbler.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$StreamGobbler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$StreamGobbler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ShellEnvReader {
        private final long myTimeoutMillis;

        public ShellEnvReader() {
            this(20000L);
        }

        public ShellEnvReader(long timeoutMillis) {
            this.myTimeoutMillis = timeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected final Map<String, String> readShellEnv(@Nullable Map<String, String> additionalEnvironment) throws IOException {
            Path reader = PathManager.findBinFileWithException("printenv.py");
            Path envFile = Files.createTempFile("intellij-shell-env.", ".tmp", new FileAttribute[0]);
            List<String> command = this.getShellProcessCommand();
            int idx = command.indexOf(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
            if (idx >= 0) {
                command.set(idx + 1, command.get(idx + 1) + ";'" + reader.toAbsolutePath() + "' '" + envFile.toAbsolutePath() + "'");
            } else {
                command.add(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
                command.add("'" + reader.toAbsolutePath() + "' '" + envFile.toAbsolutePath() + "'");
            }
            LOG.info("loading shell env: " + String.join((CharSequence)" ", command));
            Map map = (Map)this.runProcessAndReadOutputAndEnvs(command, null, additionalEnvironment, (Path)envFile).second;
            Map map2 = map;
            if (map2 == null) {
                ShellEnvReader.$$$reportNull$$$0(0);
            }
            return map2;
            finally {
                try {
                    Files.delete(envFile);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    LOG.warn("Cannot delete temporary file", e);
                }
            }
        }

        @NotNull
        public Map<String, String> readBatEnv(@NotNull Path batchFile, List<String> args) throws Exception {
            if (batchFile == null) {
                ShellEnvReader.$$$reportNull$$$0(1);
            }
            Map map = (Map)this.readBatOutputAndEnv((Path)batchFile, args).second;
            if (map == null) {
                ShellEnvReader.$$$reportNull$$$0(2);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected Pair<String, Map<String, String>> readBatOutputAndEnv(@NotNull Path batchFile, List<String> args) throws Exception {
            if (batchFile == null) {
                ShellEnvReader.$$$reportNull$$$0(3);
            }
            Path envFile = Files.createTempFile("intellij-cmd-env.", ".tmp", new FileAttribute[0]);
            ArrayList<String> cl = new ArrayList<String>();
            cl.add(CommandLineUtil.getWinShellName());
            cl.add("/c");
            cl.add("call");
            cl.add(batchFile.toString());
            cl.addAll(args);
            cl.add("&&");
            cl.addAll(ShellEnvReader.getReadEnvCommand());
            cl.add(envFile.toString());
            cl.addAll(Arrays.asList("||", "exit", "/B", "%ERRORLEVEL%"));
            Pair<String, Map<String, String>> pair = this.runProcessAndReadOutputAndEnvs(cl, batchFile.getParent(), null, envFile);
            Pair<String, Map<String, String>> pair2 = pair;
            if (pair2 == null) {
                ShellEnvReader.$$$reportNull$$$0(4);
            }
            return pair2;
            finally {
                try {
                    Files.delete(envFile);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    LOG.warn("Cannot delete temporary file", e);
                }
            }
        }

        @NotNull
        private static List<String> getReadEnvCommand() {
            List<String> list = Arrays.asList(FileUtilRt.toSystemDependentName(System.getProperty("java.home") + "/bin/java"), "-cp", PathManager.getJarPathForClass(ReadEnv.class), ReadEnv.class.getCanonicalName());
            if (list == null) {
                ShellEnvReader.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        protected final Pair<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command, @Nullable Path workingDir, @Nullable Map<String, String> scriptEnvironment, @NotNull Path envFile) throws IOException {
            if (command == null) {
                ShellEnvReader.$$$reportNull$$$0(6);
            }
            if (envFile == null) {
                ShellEnvReader.$$$reportNull$$$0(7);
            }
            ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
            if (scriptEnvironment != null) {
                builder.environment().putAll(scriptEnvironment);
            }
            if (workingDir != null) {
                builder.directory(workingDir.toFile());
            }
            builder.environment().put(EnvironmentUtil.DISABLE_OMZ_AUTO_UPDATE, "true");
            builder.environment().put(EnvironmentUtil.INTELLIJ_ENVIRONMENT_READER, "true");
            Process process = builder.start();
            StreamGobbler gobbler = new StreamGobbler(process.getInputStream());
            int exitCode = EnvironmentUtil.waitAndTerminateAfter(process, this.myTimeoutMillis);
            gobbler.stop();
            String lines = new String(Files.readAllBytes(envFile), StandardCharsets.UTF_8);
            if (exitCode != 0 || lines.isEmpty()) {
                throw new RuntimeException("command " + command + "\n\texit code:" + exitCode + " text:" + lines.length() + " out:" + gobbler.getText().trim());
            }
            return new Pair<String, Map<String, String>>(gobbler.getText(), EnvironmentUtil.parseEnv(lines));
        }

        @NotNull
        protected List<String> getShellProcessCommand() {
            String shellScript = this.getShell();
            if (StringUtilRt.isEmptyOrSpaces(shellScript)) {
                throw new RuntimeException("empty $SHELL");
            }
            if (!Files.isExecutable(Paths.get(shellScript, new String[0]))) {
                throw new RuntimeException("$SHELL points to a missing or non-executable file: " + shellScript);
            }
            List<String> list = EnvironmentUtil.buildShellProcessCommand(shellScript, true, true, false);
            if (list == null) {
                ShellEnvReader.$$$reportNull$$$0(8);
            }
            return list;
        }

        @Nullable
        protected String getShell() {
            return System.getenv(EnvironmentUtil.SHELL_VARIABLE_NAME);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "batchFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readShellEnv";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBatEnv";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBatOutputAndEnv";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadEnvCommand";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShellProcessCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "readBatEnv";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readBatOutputAndEnv";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "runProcessAndReadOutputAndEnvs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

