/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntForwardIndexAccessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(MapReduceIndex.class);
    @NotNull
    protected final IndexId<Key, Value> myIndexId;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    protected final IndexExtension<Key, Value, Input> myExtension;
    protected final AtomicLong myModificationStamp;
    protected final DataIndexer<Key, Value, Input> myIndexer;
    private final ForwardIndex myForwardIndex;
    private final ForwardIndexAccessor<Key, Value> myForwardIndexAccessor;
    @NotNull
    private final ReadWriteLock myLock;
    private final boolean myUseIntForwardIndex;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor;
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor;

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable ReadWriteLock lock) {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            MapReduceIndex.$$$reportNull$$$0(1);
        }
        this.myModificationStamp = new AtomicLong();
        this.myLowMemoryFlusher = LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                try {
                    MapReduceIndex.this.myLock.readLock().lock();
                    try {
                        MapReduceIndex.this.myStorage.clearCaches();
                    }
                    finally {
                        MapReduceIndex.this.myLock.readLock().unlock();
                    }
                    MapReduceIndex.this.flush();
                }
                catch (Throwable e) {
                    MapReduceIndex.this.requestRebuild(e);
                }
            }
        });
        this.myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

            @Override
            public void process(Key key, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            }
        };
        this.myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = storage;
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myForwardIndex = forwardIndex;
        this.myForwardIndexAccessor = forwardIndexAccessor;
        this.myUseIntForwardIndex = forwardIndex instanceof IntForwardIndex && forwardIndexAccessor instanceof IntForwardIndexAccessor;
        LOG.assertTrue(forwardIndex instanceof IntForwardIndex == forwardIndexAccessor instanceof IntForwardIndexAccessor, "Invalid index configuration");
        this.myLock = lock == null ? new ReentrantReadWriteLock() : lock;
    }

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor) {
        if (extension == null) {
            MapReduceIndex.$$$reportNull$$$0(2);
        }
        if (storage == null) {
            MapReduceIndex.$$$reportNull$$$0(3);
        }
        this(extension, storage, forwardIndex, forwardIndexAccessor, null);
    }

    public ForwardIndex getForwardIndex() {
        return this.myForwardIndex;
    }

    public ForwardIndexAccessor<Key, Value> getForwardIndexAccessor() {
        return this.myForwardIndexAccessor;
    }

    @NotNull
    public IndexExtension<Key, Value, Input> getExtension() {
        IndexExtension<Key, Value, Input> indexExtension = this.myExtension;
        if (indexExtension == null) {
            MapReduceIndex.$$$reportNull$$$0(4);
        }
        return indexExtension;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            MapReduceIndex.$$$reportNull$$$0(5);
        }
        return indexStorage;
    }

    @NotNull
    public final ReadWriteLock getLock() {
        ReadWriteLock readWriteLock = this.myLock;
        if (readWriteLock == null) {
            MapReduceIndex.$$$reportNull$$$0(6);
        }
        return readWriteLock;
    }

    @Override
    public void clear() {
        this.myLock.writeLock().lock();
        try {
            this.myModificationStamp.incrementAndGet();
            this.doClear();
        }
        catch (StorageException | IOException e) {
            LOG.error(e);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        this.myLock.readLock().lock();
        try {
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.force();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        this.myLock.writeLock().lock();
        try {
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myDisposed = true;
            this.myLock.writeLock().unlock();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            MapReduceIndex.$$$reportNull$$$0(7);
        }
        this.myLock.readLock().lock();
        if (this.myDisposed) {
            ValueContainerImpl valueContainerImpl = new ValueContainerImpl();
            ValueContainerImpl valueContainerImpl2 = valueContainerImpl;
            if (valueContainerImpl2 == null) {
                MapReduceIndex.$$$reportNull$$$0(8);
            }
            return valueContainerImpl2;
        }
        IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            MapReduceIndex.$$$reportNull$$$0(9);
        }
        return valueContainer2;
        finally {
            IndexDebugProperties.DEBUG_INDEX_ID.set(null);
            this.myLock.readLock().unlock();
        }
    }

    @Override
    @NotNull
    public final Computable<Boolean> mapInputAndPrepareUpdate(int inputId, @Nullable Input content) throws MapInputException, ProcessCanceledException {
        InputData<Key, Value> data;
        try {
            data = this.mapInput(inputId, content);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MapInputException("Failed to map data for input " + inputId + " for index " + this.myIndexId.getName(), e);
        }
        UpdateData<Key, Value> updateData = new UpdateData<Key, Value>(inputId, data.getKeyValues(), () -> this.getKeysDiffBuilder(inputId), this.myIndexId, () -> this.updateForwardIndex(inputId, data));
        Computable<Boolean> computable = () -> {
            try {
                this.updateWithMap(updateData);
            }
            catch (ProcessCanceledException | StorageException ex) {
                String message = "An exception during updateWithMap(). Index " + this.myIndexId.getName() + " will be rebuilt.";
                if (ex instanceof ProcessCanceledException) {
                    LOG.error(message, ex);
                } else {
                    LOG.info(message, ex);
                }
                this.requestRebuild(ex);
                return false;
            }
            return true;
        };
        if (computable == null) {
            MapReduceIndex.$$$reportNull$$$0(10);
        }
        return computable;
    }

    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data) throws IOException {
        if (data == null) {
            MapReduceIndex.$$$reportNull$$$0(11);
        }
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                ((IntForwardIndex)this.myForwardIndex).putInt(inputId, ((IntForwardIndexAccessor)this.myForwardIndexAccessor).serializeIndexedDataToInt(data));
            } else {
                this.myForwardIndex.put(inputId, this.myForwardIndexAccessor.serializeIndexedData(data));
            }
        }
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            if (this.myUseIntForwardIndex) {
                InputDataDiffBuilder inputDataDiffBuilder = ((IntForwardIndexAccessor)this.myForwardIndexAccessor).getDiffBuilderFromInt(inputId, ((IntForwardIndex)this.myForwardIndex).getInt(inputId));
                if (inputDataDiffBuilder == null) {
                    MapReduceIndex.$$$reportNull$$$0(12);
                }
                return inputDataDiffBuilder;
            }
            InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.myForwardIndexAccessor.getDiffBuilder(inputId, this.myForwardIndex.get(inputId));
            if (inputDataDiffBuilder == null) {
                MapReduceIndex.$$$reportNull$$$0(13);
            }
            return inputDataDiffBuilder;
        }
        return new EmptyInputDataDiffBuilder(inputId);
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable Input content) {
        if (content == null) {
            InputData inputData = InputData.empty();
            if (inputData == null) {
                MapReduceIndex.$$$reportNull$$$0(14);
            }
            return inputData;
        }
        Map<Key, Value> data = this.mapByIndexer(inputId, content);
        MapReduceIndex.checkValuesHaveProperEqualsAndHashCode(data, this.myIndexId, this.myValueExternalizer);
        this.checkCanceled();
        return new InputData<Key, Value>(data);
    }

    @NotNull
    protected Map<Key, Value> mapByIndexer(int inputId, @NotNull Input content) {
        if (content == null) {
            MapReduceIndex.$$$reportNull$$$0(15);
        }
        Map<Key, Value> map = this.myIndexer.map(content);
        if (map == null) {
            MapReduceIndex.$$$reportNull$$$0(16);
        }
        return map;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MapReduceIndex.$$$reportNull$$$0(17);
        }
        this.myLock.writeLock().lock();
        try {
            IndexId<?, ?> oldIndexId = IndexDebugProperties.DEBUG_INDEX_ID.get();
            try {
                IndexDebugProperties.DEBUG_INDEX_ID.set(this.myIndexId);
                boolean hasDifference = updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                if (hasDifference) {
                    updateData.updateForwardIndex();
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.set(oldIndexId);
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    public static <Key, Value> void checkValuesHaveProperEqualsAndHashCode(@NotNull Map<Key, Value> data, @NotNull IndexId<Key, Value> indexId, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (data == null) {
            MapReduceIndex.$$$reportNull$$$0(18);
        }
        if (indexId == null) {
            MapReduceIndex.$$$reportNull$$$0(19);
        }
        if (valueExternalizer == null) {
            MapReduceIndex.$$$reportNull$$$0(20);
        }
        if (IndexDebugProperties.DEBUG) {
            for (Map.Entry<Key, Value> e : data.entrySet()) {
                Value value = e.getValue();
                if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                    LOG.error("Index " + indexId + " violates equals / hashCode contract for Value parameter");
                }
                try {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    DataOutputStream outputStream = new DataOutputStream(out);
                    valueExternalizer.save(outputStream, value);
                    outputStream.close();
                    Value deserializedValue = valueExternalizer.read(new DataInputStream(out.toInputStream()));
                    if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                    LOG.error("Index " + indexId + " deserialization violates equals / hashCode contract for Value parameter");
                }
                catch (IOException ex) {
                    LOG.error(ex);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/MapReduceIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInputAndPrepareUpdate";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysDiffBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mapInput";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mapByIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateForwardIndex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapByIndexer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkValuesHaveProperEqualsAndHashCode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MapInputException
    extends RuntimeException {
        public MapInputException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

