/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TagNameVariantCollector {
    public static List<XmlElementDescriptor> getTagDescriptors(XmlTag element, Collection<String> namespaces, @Nullable List<? super String> nsInfo) {
        XmlElementDescriptor elementDescriptor = null;
        String elementNamespace = element.getNamespacePrefix().isEmpty() ? null : element.getNamespace();
        HashMap<String, XmlElementDescriptor> descriptorsMap = new HashMap<String, XmlElementDescriptor>();
        PsiElement context = element.getParent();
        PsiElement curElement = element.getParent();
        while (curElement instanceof XmlTag) {
            XmlElementDescriptor descriptor2;
            XmlTag declarationTag = (XmlTag)curElement;
            String namespace = declarationTag.getNamespace();
            if (!descriptorsMap.containsKey(namespace) && (descriptor2 = declarationTag.getDescriptor()) != null) {
                descriptorsMap.put(namespace, descriptor2);
                if (elementDescriptor == null) {
                    elementDescriptor = descriptor2;
                    if (elementNamespace == null) {
                        elementNamespace = namespace;
                    }
                }
            }
            curElement = curElement.getContext();
        }
        HashSet visited = new HashSet();
        XmlExtension extension = XmlExtension.getExtension(element.getContainingFile());
        ArrayList variants = new ArrayList();
        for (String namespace : namespaces) {
            int initialSize = variants.size();
            TagNameVariantCollector.processVariantsInNamespace(namespace, element, variants, elementDescriptor, elementNamespace, descriptorsMap, visited, context instanceof XmlTag ? (XmlTag)context : element, extension);
            if (nsInfo == null) continue;
            for (int i = initialSize; i < variants.size(); ++i) {
                XmlElementDescriptor descriptor3 = (XmlElementDescriptor)variants.get(i);
                nsInfo.add(descriptor3 instanceof XmlElementDescriptorImpl && !(descriptor3 instanceof RelaxedHtmlFromSchemaElementDescriptor) ? ((XmlElementDescriptorImpl)descriptor3).getNamespaceByContext((PsiElement)element) : namespace);
            }
        }
        boolean hasPrefix = StringUtil.isNotEmpty((String)element.getNamespacePrefix());
        return ContainerUtil.filter(variants, descriptor -> {
            if (descriptor instanceof AnyXmlElementDescriptor) {
                return false;
            }
            return !hasPrefix || !(descriptor instanceof XmlElementDescriptorImpl) || namespaces.contains(((XmlElementDescriptorImpl)descriptor).getNamespace());
        });
    }

    private static void processVariantsInNamespace(String namespace, XmlTag element, List<? super XmlElementDescriptor> variants, XmlElementDescriptor elementDescriptor, String elementNamespace, Map<String, XmlElementDescriptor> descriptorsMap, Set<? super XmlNSDescriptor> visited, XmlTag parent, XmlExtension extension) {
        if (descriptorsMap.containsKey(namespace)) {
            XmlElementDescriptor descriptor = descriptorsMap.get(namespace);
            if (TagNameVariantCollector.isAcceptableNs(element, elementDescriptor, elementNamespace, namespace)) {
                for (XmlElementDescriptor containedDescriptor : descriptor.getElementsDescriptors(parent)) {
                    if (containedDescriptor == null) continue;
                    variants.add((XmlElementDescriptor)containedDescriptor);
                }
            }
            if (element instanceof HtmlTag) {
                HtmlUtil.addHtmlSpecificCompletions(descriptor, element, variants);
            }
            visited.add((XmlNSDescriptor)descriptor.getNSDescriptor());
        } else {
            if (namespace == null) {
                return;
            }
            if (namespace.isEmpty() && !visited.isEmpty()) {
                return;
            }
            XmlNSDescriptor nsDescriptor = TagNameVariantCollector.getDescriptor(element, namespace, true, extension);
            if (nsDescriptor == null) {
                if (!descriptorsMap.isEmpty()) {
                    return;
                }
                nsDescriptor = TagNameVariantCollector.getDescriptor(element, namespace, false, extension);
            }
            if (nsDescriptor != null && !visited.contains(nsDescriptor) && TagNameVariantCollector.isAcceptableNs(element, elementDescriptor, elementNamespace, namespace)) {
                XmlElementDescriptor parentDescriptor;
                visited.add((XmlNSDescriptor)nsDescriptor);
                XmlElementDescriptor[] rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors((XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class));
                XmlTag parentTag = extension.getParentTagForNamespace(element, nsDescriptor);
                if (parentTag == element.getParentTag()) {
                    parentDescriptor = elementDescriptor;
                } else {
                    assert (parentTag != null);
                    parentDescriptor = parentTag.getDescriptor();
                }
                for (XmlElementDescriptor candidateDescriptor : rootElementsDescriptors) {
                    if (candidateDescriptor == null || !TagNameVariantCollector.couldContainDescriptor(parentTag, parentDescriptor, candidateDescriptor, namespace, false)) continue;
                    variants.add((XmlElementDescriptor)candidateDescriptor);
                }
            }
        }
    }

    private static XmlNSDescriptor getDescriptor(XmlTag element, String namespace, boolean strict, XmlExtension extension) {
        return extension.getNSDescriptor(element, namespace, strict);
    }

    static boolean couldContainDescriptor(XmlTag parentTag, XmlElementDescriptor parentDescriptor, XmlElementDescriptor childDescriptor, String childNamespace, boolean strict) {
        if (XmlUtil.nsFromTemplateFramework(childNamespace)) {
            return true;
        }
        if (parentTag == null) {
            return true;
        }
        if (parentDescriptor == null) {
            return false;
        }
        XmlTag childTag = parentTag.createChildTag(childDescriptor.getName(), childNamespace, null, false);
        childTag.putUserData(XmlElement.INCLUDING_ELEMENT, (Object)parentTag);
        XmlElementDescriptor descriptor = parentDescriptor.getElementDescriptor(childTag, parentTag);
        return descriptor != null && (!strict || !(descriptor instanceof AnyXmlElementDescriptor));
    }

    private static boolean isAcceptableNs(XmlTag element, XmlElementDescriptor elementDescriptor, String elementNamespace, String namespace) {
        return !(elementDescriptor instanceof XmlElementDescriptorAwareAboutChildren) || elementNamespace == null || elementNamespace.equals(namespace) || ((XmlElementDescriptorAwareAboutChildren)elementDescriptor).allowElementsFromNamespace(namespace, element.getParentTag());
    }

    public static boolean couldContain(XmlTag parent, XmlTag child) {
        return TagNameVariantCollector.couldContainDescriptor(parent, parent.getDescriptor(), child.getDescriptor(), child.getNamespace(), true);
    }
}

