/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.HgRemoteStatusUpdater;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;

final class HgIncomingOutgoingWidget
extends EditorBasedWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget.Multiframe {
    private static final String INCOMING_WIDGET_ID = "InHgIncomingOutgoingWidget";
    private static final String OUTGOING_WIDGET_ID = "OutHgIncomingOutgoingWidget";
    @NotNull
    private final HgVcs myVcs;
    private final boolean myIsIncoming;
    @NotNull
    private final Icon myEnabledIcon;
    @NotNull
    private final Icon myDisabledIcon;
    private volatile String myTooltip;
    private Icon myCurrentIcon;

    public HgIncomingOutgoingWidget(@NotNull HgVcs vcs, boolean isIncoming) {
        if (vcs == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(0);
        }
        super(vcs.getProject());
        this.myTooltip = "";
        this.myIsIncoming = isIncoming;
        this.myVcs = vcs;
        this.myEnabledIcon = this.myIsIncoming ? AllIcons.Ide.IncomingChangesOn : AllIcons.Ide.OutgoingChangesOn;
        this.myCurrentIcon = this.myDisabledIcon = IconLoader.getDisabledIcon((Icon)this.myEnabledIcon);
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> this.updateLater());
        busConnection.subscribe(HgVcs.STATUS_TOPIC, (project, root) -> this.updateLater());
        busConnection.subscribe(HgVcs.REMOTE_TOPIC, (project, root) -> this.updateLater());
        busConnection.subscribe(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC, (Object)new HgWidgetUpdater(){

            @Override
            public void update() {
                HgIncomingOutgoingWidget.this.updateLater();
            }
        });
        this.updateLater();
    }

    public StatusBarWidget copy() {
        return new HgIncomingOutgoingWidget(this.myVcs, this.myIsIncoming);
    }

    @NotNull
    public String ID() {
        return this.myIsIncoming ? INCOMING_WIDGET_ID : OUTGOING_WIDGET_ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(1);
        }
        this.updateLater();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(2);
        }
        if (file == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(3);
        }
        this.updateLater();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(4);
        }
        if (file == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(5);
        }
        this.updateLater();
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> this.updateLater();
    }

    public void updateLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            HgRemoteStatusUpdater statusUpdater = this.myVcs.getRemoteStatusUpdater();
            if (statusUpdater == null) {
                return;
            }
            HgChangesetStatus status = statusUpdater.getStatus(this.myIsIncoming);
            boolean changesAvailable = status.getNumChanges() > 0;
            this.myCurrentIcon = changesAvailable ? this.myEnabledIcon : this.myDisabledIcon;
            String string = this.myTooltip = changesAvailable ? "\n" + status.getToolTip() : HgBundle.message("no.changes.available", new Object[0]);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        });
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myCurrentIcon;
        if (icon == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(6);
        }
        return icon;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyWidgetFactory
    implements StatusBarWidgetFactory {
        private final boolean myIsIncoming;

        protected MyWidgetFactory(boolean isIncoming) {
            this.myIsIncoming = isIncoming;
        }

        public boolean isAvailable(@NotNull Project project) {
            if (project == null) {
                MyWidgetFactory.$$$reportNull$$$0(0);
            }
            return HgRemoteStatusUpdater.isCheckingEnabled(project);
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                MyWidgetFactory.$$$reportNull$$$0(1);
            }
            HgVcs hgVcs = Objects.requireNonNull(HgVcs.getInstance(project));
            return new HgIncomingOutgoingWidget(hgVcs, this.myIsIncoming);
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            if (widget == null) {
                MyWidgetFactory.$$$reportNull$$$0(2);
            }
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                MyWidgetFactory.$$$reportNull$$$0(3);
            }
            return true;
        }

        @NotNull
        public String getId() {
            return this.myIsIncoming ? HgIncomingOutgoingWidget.INCOMING_WIDGET_ID : HgIncomingOutgoingWidget.OUTGOING_WIDGET_ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            String string = this.myIsIncoming ? HgBundle.message("hg4idea.status.bar.incoming.widget.name", new Object[0]) : HgBundle.message("hg4idea.status.bar.outgoing.widget.name", new Object[0]);
            if (string == null) {
                MyWidgetFactory.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widget";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$MyWidgetFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$MyWidgetFactory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class OutgoingFactory
    extends MyWidgetFactory {
        public OutgoingFactory() {
            super(false);
        }
    }

    public static class IncomingFactory
    extends MyWidgetFactory {
        public IncomingFactory() {
            super(true);
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener,
    HgWidgetUpdater {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            if (project == null) {
                Listener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void mappingChanged() {
            this.updateVisibility();
        }

        @Override
        public void updateVisibility() {
            StatusBarWidgetsManager widgetsManager = (StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class);
            widgetsManager.updateWidget(IncomingFactory.class);
            widgetsManager.updateWidget(OutgoingFactory.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget$Listener", "<init>"));
        }
    }
}

