/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.a11y.brlapi.ConnectException;
import org.a11y.brlapi.ConnectionSettings;
import org.a11y.brlapi.DisplaySize;
import org.a11y.brlapi.NativeComponent;
import org.a11y.brlapi.ParameterWatcher;
import org.a11y.brlapi.WriteArguments;

public class ConnectionBase
extends NativeComponent
implements AutoCloseable {
    private long connectionHandle;
    private static final Map<Long, ConnectionBase> connections = new HashMap<Long, ConnectionBase>();
    private boolean hasBecomeUnusable = false;
    private final ConnectionSettings connectionSettings = new ConnectionSettings();
    private final int fileDescriptor;
    private boolean hasBeenClosed = false;

    private native int openConnection(ConnectionSettings var1, ConnectionSettings var2) throws ConnectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionBase(ConnectionSettings connectionSettings) throws ConnectException {
        this.fileDescriptor = this.openConnection(connectionSettings, this.connectionSettings);
        Map<Long, ConnectionBase> map = connections;
        synchronized (map) {
            if (connections.putIfAbsent(this.connectionHandle, this) != null) {
                throw new IllegalStateException("connection handle already mapped");
            }
        }
    }

    public final String getServerHost() {
        return this.connectionSettings.getServerHost();
    }

    public final String getAuthenticationScheme() {
        return this.connectionSettings.getAuthenticationScheme();
    }

    public final int getFileDescriptor() {
        return this.fileDescriptor;
    }

    private native void closeConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (!this.hasBeenClosed) {
                Map<Long, ConnectionBase> map = connections;
                synchronized (map) {
                    connections.remove(this.connectionHandle);
                }
                this.closeConnection();
                this.hasBeenClosed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionBase getConnection(long l) {
        Map<Long, ConnectionBase> map = connections;
        synchronized (map) {
            return connections.get(l);
        }
    }

    public static void setUnusable(long l) {
        ConnectionBase connectionBase = ConnectionBase.getConnection(l);
        connectionBase.hasBecomeUnusable = true;
    }

    public final boolean isUnusable() {
        return this.hasBecomeUnusable;
    }

    public native String getDriverName();

    public native String getModelIdentifier();

    public native DisplaySize getDisplaySize();

    public native void pause(int var1) throws InterruptedIOException;

    public native int enterTtyMode(int var1, String var2);

    public native void enterTtyModeWithPath(String var1, int ... var2);

    public native void leaveTtyMode();

    public native void setFocus(int var1);

    protected native void writeText(int var1, String var2);

    protected native void writeDots(byte[] var1);

    public native void write(WriteArguments var1);

    public native Long readKey(boolean var1) throws InterruptedIOException;

    public native long readKeyWithTimeout(int var1) throws InterruptedIOException, TimeoutException;

    public native void ignoreKeys(long var1, long[] var3);

    public native void acceptKeys(long var1, long[] var3);

    public native void ignoreAllKeys();

    public native void acceptAllKeys();

    public native void ignoreKeyRanges(long[][] var1);

    public native void acceptKeyRanges(long[][] var1);

    public native void enterRawMode(String var1);

    public native void leaveRawMode();

    public native int sendRaw(byte[] var1);

    public native int recvRaw(byte[] var1) throws InterruptedIOException;

    public native Object getParameter(int var1, long var2, boolean var4);

    public native void setParameter(int var1, long var2, boolean var4, Object var5);

    public native long watchParameter(int var1, long var2, boolean var4, ParameterWatcher var5);

    public static native void unwatchParameter(long var0);
}

