/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Strings {
    private static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    private Strings() {
    }

    public static boolean isAbbreviation(String string, String string2) {
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        if (n > string.length()) {
            return false;
        }
        return string.regionMatches(true, 0, string2, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern getPattern(String string) {
        Map<String, Pattern> map = patternCache;
        synchronized (map) {
            return patternCache.computeIfAbsent(string, Pattern::compile);
        }
    }

    public static Matcher getMatcher(String string, String string2) {
        return Strings.getPattern(string).matcher(string2);
    }

    public static String replaceAll(String string, String string2, String string3) {
        return Strings.getMatcher(string2, string).replaceAll(string3);
    }

    public static String wordify(String string) {
        if (!(string = Strings.replaceAll(string, "^\\s*(.*?)\\s*$", "$1")).isEmpty()) {
            string = Strings.replaceAll(string, "(?<=.)(?=\\p{Upper})", " ");
            string = Strings.replaceAll(string, "\\s+", " ");
        }
        return string;
    }

    public static int findNonemptyLine(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                n2 = i + 1;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return n2;
    }

    public static int findTrailingWhitespace(CharSequence charSequence) {
        int n = charSequence.length();
        while (--n >= 0 && Character.isWhitespace(charSequence.charAt(n))) {
        }
        return n + 1;
    }

    public static String removeTrailingWhitespace(String string) {
        return string.substring(0, Strings.findTrailingWhitespace(string));
    }

    public static String compressWhitespace(String string) {
        if (!(string = Strings.removeTrailingWhitespace(string)).isEmpty()) {
            string = Strings.replaceAll(string, "(?<=\\S)\\s+", " ");
        }
        return string;
    }

    public static String compressEmptyLines(String string) {
        return Strings.replaceAll(string, "\n{2,}", "\n\n");
    }

    public static String formatParagraphs(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            int n4 = string.indexOf(10, n3);
            if (n4 < 0) {
                n4 = n2;
            }
            if (!(string2 = Strings.compressWhitespace(string.substring(n3, n4))).isEmpty()) {
                if (!Character.isWhitespace(string2.charAt(0))) {
                    int n5;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    while (string2.length() > n && ((n5 = string2.lastIndexOf(32, n)) >= 0 || (n5 = string2.indexOf(32, n)) >= 0)) {
                        stringBuilder.append(string2.substring(0, n5)).append('\n');
                        string2 = string2.substring(n5 + 1);
                    }
                }
                stringBuilder.append(string2);
            }
            stringBuilder.append('\n');
            n3 = n4 + 1;
        }
        stringBuilder.setLength(Strings.findTrailingWhitespace(stringBuilder));
        stringBuilder.delete(0, Strings.findNonemptyLine(stringBuilder));
        return Strings.compressEmptyLines(stringBuilder.toString());
    }

    public static String formatParagraphs(String string) {
        return Strings.formatParagraphs(string, 72);
    }
}

