/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class SecurityDialogPanel
extends JPanel {
    protected SecurityDialog parent;
    protected JComponent initialFocusComponent = null;
    CertVerifier certVerifier = null;

    public SecurityDialogPanel(SecurityDialog dialog, CertVerifier certVerifier) {
        this.parent = dialog;
        this.certVerifier = certVerifier;
        this.setLayout(new BorderLayout());
    }

    public SecurityDialogPanel(SecurityDialog dialog) {
        this.parent = dialog;
        this.setLayout(new BorderLayout());
    }

    public static String htmlWrap(String s) {
        return "<html>" + s + "</html>";
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.requestFocusOnDefaultButton();
    }

    public void requestFocusOnDefaultButton() {
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocusInWindow();
        }
    }

    public abstract DialogResult getDefaultNegativeAnswer();

    public abstract DialogResult getDefaultPositiveAnswer();

    public String getText() {
        String s = this.traverse(this);
        if (s != null) {
            s = s.replace("<html>", "").replace("</html>", "").replace("<head>", "").replace("</head>", "").replace("<body>", "").replace("</body>", "").replace("<br>", PlainTextFormatter.getLineSeparator()).replace("<BR>", PlainTextFormatter.getLineSeparator()).replace("<br/>", PlainTextFormatter.getLineSeparator()).replace("<BR/>", PlainTextFormatter.getLineSeparator());
            s = s.replaceAll("(?m)^\\s+$", "");
            while (s.contains(PlainTextFormatter.getLineSeparator() + PlainTextFormatter.getLineSeparator())) {
                s = s.replace(PlainTextFormatter.getLineSeparator() + PlainTextFormatter.getLineSeparator(), PlainTextFormatter.getLineSeparator());
            }
        }
        return s;
    }

    private String traverse(Container co) {
        return this.traverse(co, true, JButton.class, JRadioButton.class, JCheckBox.class);
    }

    private String traverse(Container co, boolean skipClassName, Class ... skipClasses) {
        Component[] c;
        StringBuilder sb = new StringBuilder();
        block0: for (Component c1 : c = co.getComponents()) {
            Object s;
            if (c1 instanceof Container) {
                s = this.traverse((Container)c1);
                sb.append((String)s);
            }
            for (Class clazz : skipClasses) {
                if (c1.getClass() == clazz) continue block0;
            }
            Method getText = this.getGetText(c1.getClass());
            s = getText != null ? this.getText(c1, getText) : c1.toString();
            if (s == null || ((String)(s = ((String)s).trim())).isEmpty()) continue;
            if (!skipClassName) {
                sb.append((String)s).append(PlainTextFormatter.getLineSeparator());
                continue;
            }
            if (((String)s).contains(c1.getClass().getSimpleName())) continue;
            sb.append((String)s).append(PlainTextFormatter.getLineSeparator());
        }
        return sb.toString();
    }

    private Method getGetText(Class aClass) {
        try {
            String methodName = "getText";
            return aClass.getMethod(methodName, new Class[0]);
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return null;
        }
    }

    private String getText(Component c1, Method getText) {
        try {
            return (String)getText.invoke((Object)c1, new Object[0]);
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return null;
        }
    }

    public abstract DialogResult readFromStdIn(String var1);

    public abstract String helpToStdIn();
}

