/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import java.util.List;

public class IMAPResponse {
    public static final String UNTAGGED = "*";
    public static final String CONTINUATION = "+";
    protected String tag = null;
    protected String id = null;
    protected int count = -1;
    protected String mailbox = null;
    protected List code = null;
    protected String text;

    public String getTag() {
        return this.tag;
    }

    public boolean isTagged() {
        return this.tag != UNTAGGED && this.tag != CONTINUATION;
    }

    public boolean isUntagged() {
        return this.tag == UNTAGGED;
    }

    public boolean isContinuation() {
        return this.tag == CONTINUATION;
    }

    public String getID() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public List getResponseCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String toANSIString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tag);
        if (this.count != -1) {
            stringBuffer.append(" \u001b[00;31m");
            stringBuffer.append(this.count);
            stringBuffer.append("\u001b[00m");
        }
        if (!this.isContinuation()) {
            stringBuffer.append(" \u001b[01m");
            stringBuffer.append(this.id);
            stringBuffer.append("\u001b[00m");
        }
        if (this.mailbox != null) {
            stringBuffer.append(" \u001b[00;35m");
            stringBuffer.append(this.mailbox);
            stringBuffer.append("\u001b[00m");
        }
        if (this.code != null) {
            stringBuffer.append(" \u001b[00;36m");
            stringBuffer.append(this.code);
            stringBuffer.append("\u001b[00m");
        }
        if (this.text != null) {
            stringBuffer.append(" \u001b[00;33m");
            stringBuffer.append(this.text);
            stringBuffer.append("\u001b[00m");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.tag);
        if (this.count != -1) {
            stringBuffer.append(' ');
            stringBuffer.append(this.count);
        }
        if (!this.isContinuation()) {
            stringBuffer.append(' ');
            stringBuffer.append(this.id);
        }
        if (this.mailbox != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.mailbox);
        }
        if (this.code != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.code);
        }
        if (this.text != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.text);
        }
        return stringBuffer.toString();
    }
}

