/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.ConcurrentLocksPrinter;
import sun.jvm.hotspot.runtime.DeadlockDetector;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;

public class StackTrace
extends Tool {
    private boolean verbose;
    private boolean concurrentLocks;

    public StackTrace(boolean v, boolean concurrentLocks) {
        this.verbose = v;
        this.concurrentLocks = concurrentLocks;
    }

    public StackTrace() {
        this(true, true);
    }

    @Override
    public void run() {
        this.run(System.out);
    }

    public void run(PrintStream tty) {
        try {
            DeadlockDetector.print(tty);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            tty.println("Can't print deadlocks:" + exp.getMessage());
        }
        try {
            ConcurrentLocksPrinter concLocksPrinter = null;
            if (this.concurrentLocks) {
                concLocksPrinter = new ConcurrentLocksPrinter();
            }
            Threads threads = VM.getVM().getThreads();
            int i = 1;
            JavaThread cur = threads.first();
            while (cur != null) {
                if (cur.isJavaThread()) {
                    Address sp = cur.getLastJavaSP();
                    tty.print("Thread ");
                    cur.printThreadIDOn(tty);
                    tty.print(": (state = " + cur.getThreadState());
                    if (this.verbose) {
                        tty.println(", current Java SP = " + sp);
                    }
                    tty.println(')');
                    try {
                        for (JavaVFrame vf = cur.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
                            Method method = vf.getMethod();
                            tty.print(" - " + method.externalNameAndSignature() + " @bci=" + vf.getBCI());
                            int lineNumber = method.getLineNumberFromBCI(vf.getBCI());
                            if (lineNumber != -1) {
                                tty.print(", line=" + lineNumber);
                            }
                            if (this.verbose) {
                                Address pc = vf.getFrame().getPC();
                                if (pc != null) {
                                    tty.print(", pc=" + pc);
                                }
                                tty.print(", methodOop=" + method.getHandle());
                            }
                            if (vf.isCompiledFrame()) {
                                tty.print(" (Compiled frame");
                                if (vf.isDeoptimized()) {
                                    tty.print(" [deoptimized]");
                                }
                            }
                            if (vf.isInterpretedFrame()) {
                                tty.print(" (Interpreted frame");
                            }
                            if (vf.mayBeImpreciseDbg()) {
                                tty.print("; information may be imprecise");
                            }
                            tty.println(")");
                        }
                    }
                    catch (Exception e) {
                        tty.println("Error occurred during stack walking:");
                        e.printStackTrace();
                    }
                    tty.println();
                    if (this.concurrentLocks) {
                        concLocksPrinter.print(cur, tty);
                    }
                    tty.println();
                }
                cur = cur.next();
                ++i;
            }
        }
        catch (AddressException e) {
            System.err.println("Error accessing address 0x" + Long.toHexString(e.getAddress()));
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        StackTrace st = new StackTrace();
        st.start(args);
        st.stop();
    }
}

