/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import sun.security.krb5.Credentials;
import sun.security.krb5.PrincipalName;

final class ReferralsCache {
    private static Map<ReferralCacheKey, Map<String, ReferralCacheEntry>> referralsMap = new HashMap<ReferralCacheKey, Map<String, ReferralCacheEntry>>();

    ReferralsCache() {
    }

    static synchronized void put(PrincipalName principalName, PrincipalName principalName2, String string, String string2, Credentials credentials) {
        ReferralCacheKey referralCacheKey = new ReferralCacheKey(principalName, principalName2);
        ReferralsCache.pruneExpired(referralCacheKey);
        if (credentials.getEndTime().before(new Date())) {
            return;
        }
        Map<String, ReferralCacheEntry> map = referralsMap.get(referralCacheKey);
        if (map == null) {
            map = new HashMap<String, ReferralCacheEntry>();
            referralsMap.put(referralCacheKey, map);
        }
        map.remove(string);
        ReferralCacheEntry referralCacheEntry = new ReferralCacheEntry(credentials, string2);
        map.put(string, referralCacheEntry);
        ReferralCacheEntry referralCacheEntry2 = referralCacheEntry;
        LinkedList<ReferralCacheEntry> linkedList = new LinkedList<ReferralCacheEntry>();
        while (referralCacheEntry2 != null) {
            if (linkedList.contains(referralCacheEntry2)) {
                map.remove(referralCacheEntry.getToRealm());
                break;
            }
            linkedList.add(referralCacheEntry2);
            referralCacheEntry2 = map.get(referralCacheEntry2.getToRealm());
        }
    }

    static synchronized ReferralCacheEntry get(PrincipalName principalName, PrincipalName principalName2, String string) {
        ReferralCacheEntry referralCacheEntry;
        ReferralCacheKey referralCacheKey = new ReferralCacheKey(principalName, principalName2);
        ReferralsCache.pruneExpired(referralCacheKey);
        Map<String, ReferralCacheEntry> map = referralsMap.get(referralCacheKey);
        if (map != null && (referralCacheEntry = map.get(string)) != null) {
            return referralCacheEntry;
        }
        return null;
    }

    private static void pruneExpired(ReferralCacheKey referralCacheKey) {
        Date date = new Date();
        Map<String, ReferralCacheEntry> map = referralsMap.get(referralCacheKey);
        if (map != null) {
            for (Map.Entry<String, ReferralCacheEntry> entry : map.entrySet()) {
                if (!entry.getValue().getCreds().getEndTime().before(date)) continue;
                map.remove(entry.getKey());
            }
        }
    }

    static final class ReferralCacheEntry {
        private final Credentials creds;
        private final String toRealm;

        ReferralCacheEntry(Credentials credentials, String string) {
            this.creds = credentials;
            this.toRealm = string;
        }

        Credentials getCreds() {
            return this.creds;
        }

        String getToRealm() {
            return this.toRealm;
        }
    }

    private static final class ReferralCacheKey {
        private PrincipalName cname;
        private PrincipalName sname;

        ReferralCacheKey(PrincipalName principalName, PrincipalName principalName2) {
            this.cname = principalName;
            this.sname = principalName2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ReferralCacheKey)) {
                return false;
            }
            ReferralCacheKey referralCacheKey = (ReferralCacheKey)object;
            return this.cname.equals(referralCacheKey.cname) && this.sname.equals(referralCacheKey.sname);
        }

        public int hashCode() {
            return this.cname.hashCode() + this.sname.hashCode();
        }
    }
}

