
#ifndef PLASMAQUICK_EXPORT_H
#define PLASMAQUICK_EXPORT_H

#ifdef PLASMAQUICK_STATIC_DEFINE
#  define PLASMAQUICK_EXPORT
#  define PLASMAQUICK_NO_EXPORT
#else
#  ifndef PLASMAQUICK_EXPORT
#    ifdef KF5PlasmaQuick_EXPORTS
        /* We are building this library */
#      define PLASMAQUICK_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PLASMAQUICK_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PLASMAQUICK_NO_EXPORT
#    define PLASMAQUICK_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PLASMAQUICK_DECL_DEPRECATED
#  define PLASMAQUICK_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PLASMAQUICK_DECL_DEPRECATED_EXPORT
#  define PLASMAQUICK_DECL_DEPRECATED_EXPORT PLASMAQUICK_EXPORT PLASMAQUICK_DECL_DEPRECATED
#endif

#ifndef PLASMAQUICK_DECL_DEPRECATED_NO_EXPORT
#  define PLASMAQUICK_DECL_DEPRECATED_NO_EXPORT PLASMAQUICK_NO_EXPORT PLASMAQUICK_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PLASMAQUICK_NO_DEPRECATED
#    define PLASMAQUICK_NO_DEPRECATED
#  endif
#endif

#define PLASMAQUICK_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(PLASMAQUICK_NO_DEPRECATED) && !defined(PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define PLASMAQUICK_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(PLASMAQUICK_NO_DEPRECATED_WARNINGS) && !defined(PLASMAQUICK_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define PLASMAQUICK_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define PLASMAQUICK_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(PLASMAQUICK_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define PLASMAQUICK_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(PLASMAQUICK_NO_DEPRECATED)
#  undef PLASMAQUICK_DEPRECATED
#  define PLASMAQUICK_DEPRECATED_EXPORT PLASMAQUICK_EXPORT
#  define PLASMAQUICK_DEPRECATED_NO_EXPORT PLASMAQUICK_NO_EXPORT
#elif defined(PLASMAQUICK_NO_DEPRECATED_WARNINGS)
#  define PLASMAQUICK_DEPRECATED
#  define PLASMAQUICK_DEPRECATED_EXPORT PLASMAQUICK_EXPORT
#  define PLASMAQUICK_DEPRECATED_NO_EXPORT PLASMAQUICK_NO_EXPORT
#else
#  define PLASMAQUICK_DEPRECATED PLASMAQUICK_DECL_DEPRECATED
#  define PLASMAQUICK_DEPRECATED_EXPORT PLASMAQUICK_DECL_DEPRECATED_EXPORT
#  define PLASMAQUICK_DEPRECATED_NO_EXPORT PLASMAQUICK_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PLASMAQUICK_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PLASMAQUICK_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PLASMAQUICK_NO_DEPRECATED
#  define PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54e00
#endif
#ifdef PLASMAQUICK_NO_DEPRECATED_WARNINGS
#  define PLASMAQUICK_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PLASMAQUICK_DEPRECATED_WARNINGS_SINCE
#  ifdef PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PLASMAQUICK_DEPRECATED_WARNINGS_SINCE PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PLASMAQUICK_DEPRECATED_WARNINGS_SINCE 0x54e00
#  endif
#endif

#ifndef PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PLASMAQUICK_DEPRECATED
#  define PLASMAQUICK_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > PLASMAQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PLASMAQUICK_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if PLASMAQUICK_DEPRECATED_WARNINGS_SINCE >= 0x50c00
#  define PLASMAQUICK_DEPRECATED_VERSION_5_12(text) PLASMAQUICK_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMAQUICK_DEPRECATED_VERSION_5_12(text)
#endif

#if PLASMAQUICK_DEPRECATED_WARNINGS_SINCE >= 0x51900
#  define PLASMAQUICK_DEPRECATED_VERSION_5_25(text) PLASMAQUICK_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMAQUICK_DEPRECATED_VERSION_5_25(text)
#endif

#if PLASMAQUICK_DEPRECATED_WARNINGS_SINCE >= 0x52400
#  define PLASMAQUICK_DEPRECATED_VERSION_5_36(text) PLASMAQUICK_DECL_DEPRECATED_TEXT(text)
#else
#  define PLASMAQUICK_DEPRECATED_VERSION_5_36(text)
#endif
#define PLASMAQUICK_DEPRECATED_VERSION_5(minor, text)      PLASMAQUICK_DEPRECATED_VERSION_5_##minor(text)
#define PLASMAQUICK_DEPRECATED_VERSION(major, minor, text) PLASMAQUICK_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define PLASMAQUICK_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) PLASMAQUICK_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* PLASMAQUICK_EXPORT_H */
