### R code from vignette source 'Intro2Matrix.Rnw'

###################################################
### code chunk number 1: preliminaries
###################################################
options(width=75)


###################################################
### code chunk number 2: ex1
###################################################
library(Matrix)

M <- Matrix(10 + 1:28, 4, 7)
M
tM <- t(M)


###################################################
### code chunk number 3: ex2
###################################################
(M2 <- cBind(-1, M))
M[2, 1]
M[4, ]


###################################################
### code chunk number 4: set0
###################################################
M2[, c(2,4:6)] <- 0
M2[2, ] <- 0
M2 <- rBind(0, M2, 0)
M2[1:2,2] <- M2[3,4:5] <- NA


###################################################
### code chunk number 5: asSparse
###################################################
sM <- as(M2, "sparseMatrix")
10 * sM
identical(sM * 2, sM + sM)
is(sM / 10  +  M2 %/% 2, "sparseMatrix")


###################################################
### code chunk number 6: add1
###################################################
sM + 10


###################################################
### code chunk number 7: Comp1
###################################################
Mg2 <- (sM > 2)
Mg2


###################################################
### code chunk number 8: str_mat
###################################################
str(Mg2)
summary(Mg2)


###################################################
### code chunk number 9: drop0
###################################################
Mg2 <- drop0(Mg2)
str(Mg2@x) # length 13, was 16


###################################################
### code chunk number 10: image
###################################################
data(CAex)
print(image(CAex, main = "image(CAex)")) # print(.) needed for Sweave


###################################################
### code chunk number 11: sub_logi
###################################################
sM[sM > 2]
sml <- sM[sM <= 2]
sml


###################################################
### code chunk number 12: Tsparse-class
###################################################
getClass("TsparseMatrix") # (i,j, Dim, Dimnames) slots are common to all
getClass("dgTMatrix")


###################################################
### code chunk number 13: sessionInfo
###################################################
toLatex(sessionInfo())


