/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.UnknownReference;
import java.io.IOException;
import java.util.Vector;

public class AuxData {
    private String name;
    private TeXObject[] args;

    public AuxData(String string, TeXObject[] teXObjectArray) {
        this.name = string;
        this.args = teXObjectArray;
    }

    public String getName() {
        return this.name;
    }

    public int getNumArgs() {
        return this.args.length;
    }

    public TeXObject[] getArgs() {
        return this.args;
    }

    public TeXObject getArg(int n) {
        return this.args[n];
    }

    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = teXParser.getEscChar();
        int n2 = teXParser.getBgChar();
        int n3 = teXParser.getEgChar();
        stringBuilder.appendCodePoint(n);
        stringBuilder.append(this.name);
        for (int i = 0; i < this.args.length; ++i) {
            stringBuilder.appendCodePoint(n2);
            stringBuilder.append(this.args[i].toString(teXParser));
            stringBuilder.appendCodePoint(n3);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "\\";
        String string2 = "{";
        String string3 = "}";
        stringBuilder.append(string + this.name);
        for (int i = 0; i < this.args.length; ++i) {
            stringBuilder.append(string2 + this.args[i].format() + string3);
        }
        return stringBuilder.toString();
    }

    public static TeXObject getReference(Vector<AuxData> vector, TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Group) {
            teXObject = ((Group)teXObject).toList();
        }
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
        }
        String string = teXObjectList == null ? teXObject.toString(teXParser) : teXObjectList.toString(teXParser);
        return AuxData.getReference(vector, teXParser, string);
    }

    public static TeXObject getReference(Vector<AuxData> vector, TeXParser teXParser, String string) throws IOException {
        for (AuxData auxData : vector) {
            TeXObject teXObject;
            if (!auxData.getName().equals("newlabel") || !string.equals((teXObject = auxData.getArg(0)).toString(teXParser))) continue;
            TeXObject teXObject2 = auxData.getArg(1);
            if (teXObject2 instanceof TeXObjectList) {
                TeXObject teXObject3 = (TeXObject)((TeXObjectList)teXObject2).firstElement();
                if (teXObject3 instanceof Group) {
                    return ((Group)teXObject3).toList();
                }
                return teXObject3;
            }
            return teXObject2;
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        if (teXParserListener instanceof LaTeXParserListener) {
            return ((LaTeXParserListener)teXParserListener).createUnknownReference(string);
        }
        return new UnknownReference(teXParserListener, string);
    }

    public static TeXObject getPageReference(Vector<AuxData> vector, TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Group) {
            teXObject = ((Group)teXObject).toList();
        }
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
        }
        String string = teXObjectList == null ? teXObject.toString(teXParser) : teXObjectList.toString(teXParser);
        return AuxData.getPageReference(vector, teXParser, string);
    }

    public static TeXObject getPageReference(Vector<AuxData> vector, TeXParser teXParser, String string) throws IOException {
        for (AuxData auxData : vector) {
            TeXObject teXObject;
            if (!auxData.getName().equals("newlabel") || !string.equals((teXObject = auxData.getArg(0)).toString(teXParser))) continue;
            TeXObject teXObject2 = auxData.getArg(1);
            if (teXObject2 instanceof TeXObjectList && ((TeXObjectList)teXObject2).size() > 1) {
                TeXObject teXObject3 = (TeXObject)((TeXObjectList)teXObject2).get(1);
                if (teXObject3 instanceof Group) {
                    return ((Group)teXObject3).toList();
                }
                return teXObject3;
            }
            return teXObject2;
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        if (teXParserListener instanceof LaTeXParserListener) {
            return ((LaTeXParserListener)teXParserListener).createUnknownReference(string);
        }
        return new UnknownReference(teXParserListener, string);
    }

    public static TeXObject getNameReference(Vector<AuxData> vector, TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Group) {
            teXObject = ((Group)teXObject).toList();
        }
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
        }
        String string = teXObjectList == null ? teXObject.toString(teXParser) : teXObjectList.toString(teXParser);
        return AuxData.getNameReference(vector, teXParser, string);
    }

    public static TeXObject getNameReference(Vector<AuxData> vector, TeXParser teXParser, String string) throws IOException {
        for (AuxData auxData : vector) {
            TeXObject teXObject;
            if (!auxData.getName().equals("newlabel") || !string.equals((teXObject = auxData.getArg(0)).toString(teXParser))) continue;
            TeXObject teXObject2 = auxData.getArg(1);
            if (teXObject2 instanceof TeXObjectList && ((TeXObjectList)teXObject2).size() > 2) {
                TeXObject teXObject3 = (TeXObject)((TeXObjectList)teXObject2).get(2);
                if (teXObject3 instanceof Group) {
                    return ((Group)teXObject3).toList();
                }
                return teXObject3;
            }
            return teXObject2;
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        if (teXParserListener instanceof LaTeXParserListener) {
            return ((LaTeXParserListener)teXParserListener).createUnknownReference(string);
        }
        return new UnknownReference(teXParserListener, string);
    }

    public static TeXObject getLabelForLink(Vector<AuxData> vector, TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Group) {
            teXObject = ((Group)teXObject).toList();
        }
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
        }
        String string = teXObjectList == null ? teXObject.toString(teXParser) : teXObjectList.toString(teXParser);
        return AuxData.getLabelForLink(vector, teXParser, string);
    }

    public static TeXObject getLabelForLink(Vector<AuxData> vector, TeXParser teXParser, String string) throws IOException {
        for (AuxData auxData : vector) {
            Object object;
            if (!auxData.getName().equals("newlabel")) continue;
            TeXObject teXObject = auxData.getArg(0);
            TeXObject teXObject2 = auxData.getArg(1);
            if (!(teXObject2 instanceof TeXObjectList) || ((TeXObjectList)teXObject2).size() <= 3) continue;
            Object object2 = (TeXObject)((TeXObjectList)teXObject2).get(3);
            if (object2 instanceof Group) {
                object2 = ((Group)object2).toList();
            }
            if (object2 instanceof Expandable && (object = ((Expandable)object2).expandfully(teXParser)) != null) {
                object2 = object;
            }
            if (!((String)(object = object2.toString(teXParser))).equals(string)) continue;
            return teXObject;
        }
        return null;
    }

    public static TeXObject getHyperReference(Vector<AuxData> vector, TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Group) {
            teXObject = ((Group)teXObject).toList();
        }
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
        }
        String string = teXObjectList == null ? teXObject.toString(teXParser) : teXObjectList.toString(teXParser);
        return AuxData.getHyperReference(vector, teXParser, string);
    }

    public static TeXObject getHyperReference(Vector<AuxData> vector, TeXParser teXParser, String string) throws IOException {
        for (AuxData auxData : vector) {
            TeXObject teXObject;
            if (!auxData.getName().equals("newlabel") || !string.equals((teXObject = auxData.getArg(0)).toString(teXParser))) continue;
            TeXObject teXObject2 = auxData.getArg(1);
            if (teXObject2 instanceof TeXObjectList && ((TeXObjectList)teXObject2).size() > 3) {
                TeXObject teXObject3 = (TeXObject)((TeXObjectList)teXObject2).get(3);
                if (teXObject3 instanceof Group) {
                    return ((Group)teXObject3).toList();
                }
                return teXObject3;
            }
            return teXObject2;
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        if (teXParserListener instanceof LaTeXParserListener) {
            return ((LaTeXParserListener)teXParserListener).createUnknownReference(string);
        }
        return new UnknownReference(teXParserListener, string);
    }

    public static TeXObject getCitation(Vector<AuxData> vector, TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXObjectList teXObjectList = null;
        if (teXObject instanceof Group) {
            teXObject = ((Group)teXObject).toList();
        }
        if (teXObject instanceof Expandable) {
            teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser);
        }
        String string = teXObjectList == null ? teXObject.toString(teXParser) : teXObjectList.toString(teXParser);
        return AuxData.getCitation(vector, teXParser, string);
    }

    public static TeXObject getCitation(Vector<AuxData> vector, TeXParser teXParser, String string) throws IOException {
        for (AuxData auxData : vector) {
            TeXObject teXObject;
            if (!auxData.getName().equals("bibcite") || !string.equals((teXObject = auxData.getArg(0)).toString(teXParser))) continue;
            return auxData.getArg(1);
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        if (teXParserListener instanceof LaTeXParserListener) {
            return ((LaTeXParserListener)teXParserListener).createUnknownReference(string);
        }
        return new UnknownReference(teXParserListener, string);
    }
}

