/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.MessageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.util.res.StringManager;

public class MessageInfoImpl
implements MessageInfo {
    protected static final StringManager sm = StringManager.getManager(MessageInfoImpl.class);
    public static final String IS_MANDATORY = "jakarta.security.auth.message.MessagePolicy.isMandatory";
    private final Map<String, Object> map = new HashMap<String, Object>();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public MessageInfoImpl() {
    }

    public MessageInfoImpl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.map.put(IS_MANDATORY, Boolean.toString(bl));
    }

    public Map getMap() {
        return this.map;
    }

    public Object getRequestMessage() {
        return this.request;
    }

    public Object getResponseMessage() {
        return this.response;
    }

    public void setRequestMessage(Object object) {
        if (!(object instanceof HttpServletRequest)) {
            throw new IllegalArgumentException(sm.getString("authenticator.jaspic.badRequestType", new Object[]{object.getClass().getName()}));
        }
        this.request = (HttpServletRequest)object;
    }

    public void setResponseMessage(Object object) {
        if (!(object instanceof HttpServletResponse)) {
            throw new IllegalArgumentException(sm.getString("authenticator.jaspic.badResponseType", new Object[]{object.getClass().getName()}));
        }
        this.response = (HttpServletResponse)object;
    }
}

