/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

final class StandardContextValve
extends ValveBase {
    private static final StringManager sm = StringManager.getManager(StandardContextValve.class);

    public StandardContextValve() {
        super(true);
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        MessageBytes messageBytes = request.getRequestPathMB();
        if (messageBytes.startsWithIgnoreCase("/META-INF/", 0) || messageBytes.equalsIgnoreCase("/META-INF") || messageBytes.startsWithIgnoreCase("/WEB-INF/", 0) || messageBytes.equalsIgnoreCase("/WEB-INF")) {
            response.sendError(404);
            return;
        }
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null || wrapper.isUnavailable()) {
            response.sendError(404);
            return;
        }
        try {
            response.sendAcknowledgement(ContinueResponseTiming.IMMEDIATELY);
        }
        catch (IOException iOException) {
            this.container.getLogger().error((Object)sm.getString("standardContextValve.acknowledgeException"), (Throwable)iOException);
            request.setAttribute("jakarta.servlet.error.exception", iOException);
            response.sendError(500);
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(wrapper.getPipeline().isAsyncSupported());
        }
        wrapper.getPipeline().getFirst().invoke(request, response);
    }
}

