/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class CsrfPreventionFilterBase
extends FilterBase {
    private final Log log = LogFactory.getLog(CsrfPreventionFilterBase.class);
    private String randomClass = SecureRandom.class.getName();
    private Random randomSource;
    private int denyStatus = 403;

    @Override
    protected Log getLogger() {
        return this.log;
    }

    public int getDenyStatus() {
        return this.denyStatus;
    }

    public void setDenyStatus(int n) {
        this.denyStatus = n;
    }

    public void setRandomClass(String string) {
        this.randomClass = string;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            Class<?> clazz = Class.forName(this.randomClass);
            this.randomSource = (Random)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            ServletException servletException = new ServletException(sm.getString("csrfPrevention.invalidRandomClass", new Object[]{this.randomClass}), (Throwable)reflectiveOperationException);
            throw servletException;
        }
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    protected String generateNonce() {
        byte[] byArray = new byte[16];
        StringBuilder stringBuilder = new StringBuilder();
        this.randomSource.nextBytes(byArray);
        for (byte by : byArray) {
            byte by2 = (byte)((by & 0xF0) >> 4);
            byte by3 = (byte)(by & 0xF);
            if (by2 < 10) {
                stringBuilder.append((char)(48 + by2));
            } else {
                stringBuilder.append((char)(65 + (by2 - 10)));
            }
            if (by3 < 10) {
                stringBuilder.append((char)(48 + by3));
                continue;
            }
            stringBuilder.append((char)(65 + (by3 - 10)));
        }
        return stringBuilder.toString();
    }

    protected String getRequestedPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServletPath();
        if (httpServletRequest.getPathInfo() != null) {
            string = string + httpServletRequest.getPathInfo();
        }
        return string;
    }
}

