/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.res.StringManager;

public final class CustomObjectInputStream
extends ObjectInputStream {
    private static final StringManager sm = StringManager.getManager(CustomObjectInputStream.class);
    private static final WeakHashMap<ClassLoader, Set<String>> reportedClassCache = new WeakHashMap();
    private final ClassLoader classLoader;
    private final Set<String> reportedClasses;
    private final Log log;
    private final Pattern allowedClassNamePattern;
    private final String allowedClassNameFilter;
    private final boolean warnOnFailure;

    public CustomObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        this(inputStream, classLoader, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomObjectInputStream(InputStream inputStream, ClassLoader classLoader, Log log, Pattern pattern, boolean bl) throws IOException {
        super(inputStream);
        Object object;
        if (log == null && pattern != null && bl) {
            throw new IllegalArgumentException(sm.getString("customObjectInputStream.logRequired"));
        }
        this.classLoader = classLoader;
        this.log = log;
        this.allowedClassNamePattern = pattern;
        this.allowedClassNameFilter = pattern == null ? null : pattern.toString();
        this.warnOnFailure = bl;
        Object object2 = reportedClassCache;
        synchronized (object2) {
            object = reportedClassCache.get(classLoader);
        }
        if (object == null) {
            object = Collections.newSetFromMap(new ConcurrentHashMap());
            WeakHashMap<ClassLoader, Set<String>> weakHashMap = reportedClassCache;
            synchronized (weakHashMap) {
                object2 = reportedClassCache.putIfAbsent(classLoader, (Set<String>)object);
            }
            if (object2 != null) {
                object = object2;
            }
        }
        this.reportedClasses = object;
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
        boolean bl;
        String string = objectStreamClass.getName();
        if (this.allowedClassNamePattern != null && !(bl = this.allowedClassNamePattern.matcher(string).matches())) {
            boolean bl2 = this.warnOnFailure && this.reportedClasses.add(string);
            String string2 = sm.getString("customObjectInputStream.nomatch", new Object[]{string, this.allowedClassNameFilter});
            if (bl2) {
                this.log.warn((Object)string2);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)string2);
            }
            throw new InvalidClassException(string2);
        }
        try {
            return Class.forName(string, false, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return super.resolveClass(objectStreamClass);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw classNotFoundException;
            }
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = this.classLoader.loadClass(stringArray[i]);
        }
        try {
            Class<?> clazz = Proxy.getProxyClass(this.classLoader, classArray);
            return clazz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }
}

