/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.NetMask;
import org.apache.catalina.valves.RequestFilterValve;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class RemoteCIDRValve
extends RequestFilterValve {
    private static final Log log = LogFactory.getLog(RemoteCIDRValve.class);
    private final List<NetMask> allow = new ArrayList<NetMask>();
    private final List<NetMask> deny = new ArrayList<NetMask>();

    @Override
    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    @Override
    public void setAllow(String string) {
        List<String> list = this.fillFromInput(string, this.allow);
        if (list.isEmpty()) {
            return;
        }
        this.allowValid = false;
        for (String string2 : list) {
            log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", new Object[]{"allow"}));
    }

    @Override
    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    @Override
    public void setDeny(String string) {
        List<String> list = this.fillFromInput(string, this.deny);
        if (list.isEmpty()) {
            return;
        }
        this.denyValid = false;
        for (String string2 : list) {
            log.error((Object)string2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", new Object[]{"deny"}));
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String string = this.getUsePeerAddress() ? request.getPeerAddr() : request.getRequest().getRemoteAddr();
        if (this.getAddConnectorPort()) {
            string = string + ";" + request.getConnector().getPortWithOffset();
        }
        this.process(string, request, response);
    }

    @Override
    public boolean isAllowed(String string) {
        InetAddress inetAddress;
        String string2;
        int n;
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            if (this.getAddConnectorPort()) {
                log.error((Object)sm.getString("remoteCidrValve.noPort"));
                return false;
            }
            n = -1;
            string2 = string;
        } else {
            if (!this.getAddConnectorPort()) {
                log.error((Object)sm.getString("remoteCidrValve.unexpectedPort"));
                return false;
            }
            string2 = string.substring(0, n2);
            try {
                n = Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                log.error((Object)sm.getString("remoteCidrValve.noPort"), (Throwable)numberFormatException);
                return false;
            }
        }
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            log.error((Object)sm.getString("remoteCidrValve.noRemoteIp"), (Throwable)unknownHostException);
            return false;
        }
        for (NetMask netMask : this.deny) {
            if (!(this.getAddConnectorPort() ? netMask.matches(inetAddress, n) : netMask.matches(inetAddress))) continue;
            return false;
        }
        for (NetMask netMask : this.allow) {
            if (!(this.getAddConnectorPort() ? netMask.matches(inetAddress, n) : netMask.matches(inetAddress))) continue;
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private List<String> fillFromInput(String string, List<NetMask> list) {
        list.clear();
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : string.split("\\s*,\\s*")) {
            try {
                NetMask netMask = new NetMask(string2);
                list.add(netMask);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                linkedList.add(string2 + ": " + illegalArgumentException.getMessage());
            }
        }
        return Collections.unmodifiableList(linkedList);
    }
}

