/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tagplugin;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TagPluginParser {
    private final Log log = LogFactory.getLog(TagPluginParser.class);
    private static final String PREFIX = "tag-plugins/tag-plugin";
    private final Digester digester;
    private final Map<String, String> plugins = new HashMap<String, String>();

    public TagPluginParser(ServletContext servletContext, boolean bl) {
        this.digester = DigesterFactory.newDigester(false, false, new TagPluginRuleSet(), bl);
        this.digester.setClassLoader(servletContext.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URL uRL) throws IOException, SAXException {
        try (InputStream inputStream = uRL.openStream();){
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            this.digester.setErrorHandler(xmlErrorHandler);
            this.digester.push(this);
            InputSource inputSource = new InputSource(uRL.toExternalForm());
            inputSource.setByteStream(inputStream);
            this.digester.parse(inputSource);
            if (!xmlErrorHandler.getWarnings().isEmpty() || !xmlErrorHandler.getErrors().isEmpty()) {
                xmlErrorHandler.logFindings(this.log, inputSource.getSystemId());
                if (!xmlErrorHandler.getErrors().isEmpty()) {
                    throw xmlErrorHandler.getErrors().iterator().next();
                }
            }
        }
        finally {
            this.digester.reset();
        }
    }

    public void addPlugin(String string, String string2) {
        this.plugins.put(string, string2);
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    private static class TagPluginRuleSet
    implements RuleSet {
        private TagPluginRuleSet() {
        }

        @Override
        public void addRuleInstances(Digester digester) {
            digester.addCallMethod(TagPluginParser.PREFIX, "addPlugin", 2);
            digester.addCallParam("tag-plugins/tag-plugin/tag-class", 0);
            digester.addCallParam("tag-plugins/tag-plugin/plugin-class", 1);
        }
    }
}

