/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;

public abstract class PojoEndpointBase
extends Endpoint {
    private final Log log = LogFactory.getLog(PojoEndpointBase.class);
    private static final StringManager sm = StringManager.getManager(PojoEndpointBase.class);
    private Object pojo;
    private Map<String, String> pathParameters;
    private PojoMethodMapping methodMapping;

    protected final void doOnOpen(Session session, EndpointConfig endpointConfig) {
        PojoMethodMapping pojoMethodMapping = this.getMethodMapping();
        Object object = this.getPojo();
        Map<String, String> map = this.getPathParameters();
        for (Object object2 : pojoMethodMapping.getMessageHandlers(object, map, session, endpointConfig)) {
            session.addMessageHandler(object2);
        }
        if (pojoMethodMapping.getOnOpen() != null) {
            try {
                pojoMethodMapping.getOnOpen().invoke(object, pojoMethodMapping.getOnOpenArgs(map, session, endpointConfig));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.error((Object)sm.getString("pojoEndpointBase.onOpenFail", new Object[]{object.getClass().getName()}), (Throwable)illegalAccessException);
                this.handleOnOpenOrCloseError(session, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Object object2;
                object2 = invocationTargetException.getCause();
                this.handleOnOpenOrCloseError(session, (Throwable)object2);
            }
            catch (Throwable throwable) {
                this.handleOnOpenOrCloseError(session, throwable);
            }
        }
    }

    private void handleOnOpenOrCloseError(Session session, Throwable throwable) {
        ExceptionUtils.handleThrowable((Throwable)throwable);
        this.onError(session, throwable);
        try {
            session.close();
        }
        catch (IOException iOException) {
            this.log.warn((Object)sm.getString("pojoEndpointBase.closeSessionFail"), (Throwable)iOException);
        }
    }

    public final void onClose(Session session, CloseReason closeReason) {
        if (this.methodMapping.getOnClose() != null) {
            try {
                this.methodMapping.getOnClose().invoke(this.pojo, this.methodMapping.getOnCloseArgs(this.pathParameters, session, closeReason));
            }
            catch (Throwable throwable) {
                this.log.error((Object)sm.getString("pojoEndpointBase.onCloseFail", new Object[]{this.pojo.getClass().getName()}), throwable);
                this.handleOnOpenOrCloseError(session, throwable);
            }
        }
        Set set = session.getMessageHandlers();
        for (MessageHandler messageHandler : set) {
            if (!(messageHandler instanceof PojoMessageHandlerWholeBase)) continue;
            ((PojoMessageHandlerWholeBase)messageHandler).onClose();
        }
    }

    public final void onError(Session session, Throwable throwable) {
        if (this.methodMapping.getOnError() == null) {
            this.log.error((Object)sm.getString("pojoEndpointBase.onError", new Object[]{this.pojo.getClass().getName()}), throwable);
        } else {
            try {
                this.methodMapping.getOnError().invoke(this.pojo, this.methodMapping.getOnErrorArgs(this.pathParameters, session, throwable));
            }
            catch (Throwable throwable2) {
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                this.log.error((Object)sm.getString("pojoEndpointBase.onErrorFail", new Object[]{this.pojo.getClass().getName()}), throwable2);
            }
        }
    }

    protected Object getPojo() {
        return this.pojo;
    }

    protected void setPojo(Object object) {
        this.pojo = object;
    }

    protected Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    protected void setPathParameters(Map<String, String> map) {
        this.pathParameters = map;
    }

    protected PojoMethodMapping getMethodMapping() {
        return this.methodMapping;
    }

    protected void setMethodMapping(PojoMethodMapping pojoMethodMapping) {
        this.methodMapping = pojoMethodMapping;
    }
}

