/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel;

import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.JavaClass;
import org.apache.tomcat.jakartaee.bcel.util.ClassPath;
import org.apache.tomcat.jakartaee.bcel.util.SyntheticRepository;

public abstract class Repository {
    private static org.apache.tomcat.jakartaee.bcel.util.Repository repository = SyntheticRepository.getInstance();

    public static org.apache.tomcat.jakartaee.bcel.util.Repository getRepository() {
        return repository;
    }

    public static void setRepository(org.apache.tomcat.jakartaee.bcel.util.Repository rep) {
        repository = rep;
    }

    public static JavaClass lookupClass(String class_name) throws ClassNotFoundException {
        return repository.loadClass(class_name);
    }

    public static JavaClass lookupClass(Class<?> clazz) throws ClassNotFoundException {
        return repository.loadClass(clazz);
    }

    public static ClassPath.ClassFile lookupClassFile(String class_name) {
        try {
            ClassPath path = repository.getClassPath();
            if (path == null) {
                return null;
            }
            return path.getClassFile(class_name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void clearCache() {
        repository.clear();
    }

    public static JavaClass addClass(JavaClass clazz) {
        JavaClass old = repository.findClass(clazz.getClassName());
        repository.storeClass(clazz);
        return old;
    }

    public static void removeClass(String clazz) {
        repository.removeClass(repository.findClass(clazz));
    }

    public static void removeClass(JavaClass clazz) {
        repository.removeClass(clazz);
    }

    public static JavaClass[] getSuperClasses(JavaClass clazz) throws ClassNotFoundException {
        return clazz.getSuperClasses();
    }

    public static JavaClass[] getSuperClasses(String class_name) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(class_name);
        return Repository.getSuperClasses(jc);
    }

    public static JavaClass[] getInterfaces(JavaClass clazz) throws ClassNotFoundException {
        return clazz.getAllInterfaces();
    }

    public static JavaClass[] getInterfaces(String class_name) throws ClassNotFoundException {
        return Repository.getInterfaces(Repository.lookupClass(class_name));
    }

    public static boolean instanceOf(JavaClass clazz, JavaClass super_class) throws ClassNotFoundException {
        return clazz.instanceOf(super_class);
    }

    public static boolean instanceOf(String clazz, String super_class) throws ClassNotFoundException {
        return Repository.instanceOf(Repository.lookupClass(clazz), Repository.lookupClass(super_class));
    }

    public static boolean instanceOf(JavaClass clazz, String super_class) throws ClassNotFoundException {
        return Repository.instanceOf(clazz, Repository.lookupClass(super_class));
    }

    public static boolean instanceOf(String clazz, JavaClass super_class) throws ClassNotFoundException {
        return Repository.instanceOf(Repository.lookupClass(clazz), super_class);
    }

    public static boolean implementationOf(JavaClass clazz, JavaClass inter) throws ClassNotFoundException {
        return clazz.implementationOf(inter);
    }

    public static boolean implementationOf(String clazz, String inter) throws ClassNotFoundException {
        return Repository.implementationOf(Repository.lookupClass(clazz), Repository.lookupClass(inter));
    }

    public static boolean implementationOf(JavaClass clazz, String inter) throws ClassNotFoundException {
        return Repository.implementationOf(clazz, Repository.lookupClass(inter));
    }

    public static boolean implementationOf(String clazz, JavaClass inter) throws ClassNotFoundException {
        return Repository.implementationOf(Repository.lookupClass(clazz), inter);
    }
}

