/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.Constant;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantObject;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class ConstantString
extends Constant
implements ConstantObject {
    private int stringIndex;

    public ConstantString(ConstantString c) {
        this(c.getStringIndex());
    }

    ConstantString(DataInput file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantString(int stringIndex) {
        super((byte)8);
        this.stringIndex = stringIndex;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantString(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.stringIndex);
    }

    public int getStringIndex() {
        return this.stringIndex;
    }

    public void setStringIndex(int stringIndex) {
        this.stringIndex = stringIndex;
    }

    @Override
    public String toString() {
        return super.toString() + "(stringIndex = " + this.stringIndex + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        Constant c = cp.getConstant(this.stringIndex, (byte)1);
        return ((ConstantUtf8)c).getBytes();
    }

    public String getBytes(ConstantPool cp) {
        return (String)this.getConstantValue(cp);
    }
}

