/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tomcat.util.buf.UriUtil;

public interface ConfigurationSource {
    public static final ConfigurationSource DEFAULT = new ConfigurationSource(){
        protected final File userDir = new File(System.getProperty("user.dir"));
        protected final URI userDirUri = this.userDir.toURI();

        @Override
        public Resource getResource(String string) throws IOException {
            Comparable<File> comparable;
            if (!UriUtil.isAbsoluteURI(string)) {
                comparable = new File(string);
                if (!((File)comparable).isAbsolute()) {
                    comparable = new File(this.userDir, string);
                }
                if (((File)comparable).isFile()) {
                    FileInputStream fileInputStream = new FileInputStream((File)comparable);
                    return new Resource(fileInputStream, ((File)comparable).toURI());
                }
            }
            comparable = null;
            try {
                comparable = this.userDirUri.resolve(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FileNotFoundException(string);
            }
            try {
                URL uRL = ((URI)comparable).toURL();
                return new Resource(uRL.openConnection().getInputStream(), (URI)comparable);
            }
            catch (MalformedURLException malformedURLException) {
                throw new FileNotFoundException(string);
            }
        }

        @Override
        public URI getURI(String string) {
            if (!UriUtil.isAbsoluteURI(string)) {
                File file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File(this.userDir, string);
                }
                if (file.isFile()) {
                    return file.toURI();
                }
            }
            return this.userDirUri.resolve(string);
        }
    };

    default public Resource getServerXml() throws IOException {
        return this.getConfResource("server.xml");
    }

    default public Resource getSharedWebXml() throws IOException {
        return this.getConfResource("web.xml");
    }

    default public Resource getConfResource(String string) throws IOException {
        String string2 = "conf/" + string;
        return this.getResource(string2);
    }

    public Resource getResource(String var1) throws IOException;

    public URI getURI(String var1);

    public static class Resource
    implements AutoCloseable {
        private final InputStream inputStream;
        private final URI uri;

        public Resource(InputStream inputStream, URI uRI) {
            this.inputStream = inputStream;
            this.uri = uRI;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public URI getURI() {
            return this.uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastModified() throws MalformedURLException, IOException {
            URLConnection uRLConnection = null;
            try {
                uRLConnection = this.uri.toURL().openConnection();
                long l = uRLConnection.getLastModified();
                return l;
            }
            finally {
                if (uRLConnection != null) {
                    uRLConnection.getInputStream().close();
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

