/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.util.Properties;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.membership.Membership;

public abstract class MembershipServiceBase
implements MembershipService,
MembershipListener {
    protected Properties properties = new Properties();
    protected volatile MembershipListener listener;
    protected Channel channel;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean hasMembers() {
        if (this.getMembershipProvider() == null) {
            return false;
        }
        return this.getMembershipProvider().hasMembers();
    }

    @Override
    public Member getMember(Member member) {
        if (this.getMembershipProvider() == null) {
            return null;
        }
        return this.getMembershipProvider().getMember(member);
    }

    @Override
    public Member[] getMembers() {
        if (this.getMembershipProvider() == null) {
            return Membership.EMPTY_MEMBERS;
        }
        return this.getMembershipProvider().getMembers();
    }

    @Override
    public String[] getMembersByName() {
        String[] stringArray;
        Member[] memberArray = this.getMembers();
        if (memberArray != null) {
            stringArray = new String[memberArray.length];
            for (int i = 0; i < memberArray.length; ++i) {
                stringArray[i] = memberArray[i].toString();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public Member findMemberByName(String string) {
        Member[] memberArray;
        for (Member member : memberArray = this.getMembers()) {
            if (!string.equals(member.toString())) continue;
            return member;
        }
        return null;
    }

    @Override
    public void setMembershipListener(MembershipListener membershipListener) {
        this.listener = membershipListener;
    }

    @Override
    public void removeMembershipListener() {
        this.listener = null;
    }

    @Override
    public void memberAdded(Member member) {
        MembershipListener membershipListener = this.listener;
        if (membershipListener != null) {
            membershipListener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        MembershipListener membershipListener = this.listener;
        if (membershipListener != null) {
            membershipListener.memberDisappeared(member);
        }
    }

    @Override
    public void broadcast(ChannelMessage channelMessage) throws ChannelException {
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void start() throws Exception {
        this.start(4);
        this.start(8);
    }
}

