/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.JreCompat;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

class Jre9Compat
extends JreCompat {
    private static final Method canAccessMethod;
    private static final Method getModuleMethod;
    private static final Method isExportedMethod;

    Jre9Compat() {
    }

    public static boolean isSupported() {
        return canAccessMethod != null;
    }

    @Override
    public boolean canAccess(Object object, AccessibleObject accessibleObject) {
        try {
            return (Boolean)canAccessMethod.invoke((Object)accessibleObject, object);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            return false;
        }
    }

    @Override
    public boolean isExported(Class<?> clazz) {
        try {
            String string = clazz.getPackage().getName();
            Object object = getModuleMethod.invoke(clazz, new Object[0]);
            return (Boolean)isExportedMethod.invoke(object, string);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            return false;
        }
    }

    static {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        try {
            method = AccessibleObject.class.getMethod("canAccess", Object.class);
            method2 = Class.class.getMethod("getModule", new Class[0]);
            Class<?> clazz = Class.forName("java.lang.Module");
            method3 = clazz.getMethod("isExported", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        canAccessMethod = method;
        getModuleMethod = method2;
        isExportedMethod = method3;
    }
}

