/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.apache.naming.resources.ConcurrentDateFormat;
import org.apache.naming.resources.RecyclableNamingEnumeration;

public class ResourceAttributes
implements Attributes {
    private static final long serialVersionUID = 1L;
    public static final String CREATION_DATE = "creationdate";
    public static final String ALTERNATE_CREATION_DATE = "creation-date";
    public static final String LAST_MODIFIED = "getlastmodified";
    public static final String ALTERNATE_LAST_MODIFIED = "last-modified";
    public static final String NAME = "displayname";
    public static final String TYPE = "resourcetype";
    public static final String ALTERNATE_TYPE = "content-type";
    public static final String CONTENT_TYPE = "getcontenttype";
    public static final String CONTENT_LENGTH = "getcontentlength";
    public static final String ALTERNATE_CONTENT_LENGTH = "content-length";
    public static final String ETAG = "getetag";
    public static final String ALTERNATE_ETAG = "etag";
    public static final String COLLECTION_TYPE = "<collection/>";
    @Deprecated
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    @Deprecated
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private static final ConcurrentDateFormat[] concurrentFormats = new ConcurrentDateFormat[]{new ConcurrentDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US, gmtZone), new ConcurrentDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US, gmtZone), new ConcurrentDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US, gmtZone)};
    protected boolean collection = false;
    protected long contentLength = -1L;
    protected long creation = -1L;
    protected Date creationDate = null;
    protected long lastModified = -1L;
    protected Date lastModifiedDate = null;
    protected String lastModifiedHttp = null;
    protected String mimeType = null;
    protected String name = null;
    protected String weakETag = null;
    protected String strongETag = null;
    protected Attributes attributes = null;

    public ResourceAttributes() {
    }

    public ResourceAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean isCollection() {
        if (this.attributes != null) {
            return COLLECTION_TYPE.equals(this.getResourceType());
        }
        return this.collection;
    }

    public void setCollection(boolean bl) {
        this.collection = bl;
        if (this.attributes != null) {
            String string = "";
            if (bl) {
                string = COLLECTION_TYPE;
            }
            this.attributes.put(TYPE, string);
        }
    }

    public long getContentLength() {
        Attribute attribute;
        if (this.contentLength != -1L) {
            return this.contentLength;
        }
        if (this.attributes != null && (attribute = this.attributes.get(CONTENT_LENGTH)) != null) {
            try {
                Object object = attribute.get();
                if (object instanceof Long) {
                    this.contentLength = (Long)object;
                } else {
                    try {
                        this.contentLength = Long.parseLong(object.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.contentLength;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
        if (this.attributes != null) {
            this.attributes.put(CONTENT_LENGTH, l);
        }
    }

    public long getCreation() {
        Attribute attribute;
        if (this.creation != -1L) {
            return this.creation;
        }
        if (this.creationDate != null) {
            return this.creationDate.getTime();
        }
        if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
            try {
                Object object = attribute.get();
                if (object instanceof Long) {
                    this.creation = (Long)object;
                } else if (object instanceof Date) {
                    this.creation = ((Date)object).getTime();
                    this.creationDate = (Date)object;
                } else {
                    String string = object.toString();
                    Date date = null;
                    for (int i = 0; date == null && i < concurrentFormats.length; ++i) {
                        try {
                            date = concurrentFormats[i].parse(string);
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (date != null) {
                        this.creation = date.getTime();
                        this.creationDate = date;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.creation;
    }

    @Deprecated
    public void setCreation(long l) {
        this.creation = l;
        this.creationDate = null;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, new Date(l));
        }
    }

    public Date getCreationDate() {
        Attribute attribute;
        if (this.creationDate != null) {
            return this.creationDate;
        }
        if (this.creation != -1L) {
            this.creationDate = new Date(this.creation);
            return this.creationDate;
        }
        if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
            try {
                Object object = attribute.get();
                if (object instanceof Long) {
                    this.creation = (Long)object;
                    this.creationDate = new Date(this.creation);
                } else if (object instanceof Date) {
                    this.creation = ((Date)object).getTime();
                    this.creationDate = (Date)object;
                } else {
                    String string = object.toString();
                    Date date = null;
                    for (int i = 0; date == null && i < concurrentFormats.length; ++i) {
                        try {
                            date = concurrentFormats[i].parse(string);
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (date != null) {
                        this.creation = date.getTime();
                        this.creationDate = date;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creation = date.getTime();
        this.creationDate = date;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, date);
        }
    }

    public long getLastModified() {
        Attribute attribute;
        if (this.lastModified != -1L) {
            return this.lastModified;
        }
        if (this.lastModifiedDate != null) {
            return this.lastModifiedDate.getTime();
        }
        if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
            try {
                Object object = attribute.get();
                if (object instanceof Long) {
                    this.lastModified = (Long)object;
                } else if (object instanceof Date) {
                    this.lastModified = ((Date)object).getTime();
                    this.lastModifiedDate = (Date)object;
                } else {
                    String string = object.toString();
                    Date date = null;
                    for (int i = 0; date == null && i < concurrentFormats.length; ++i) {
                        try {
                            date = concurrentFormats[i].parse(string);
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (date != null) {
                        this.lastModified = date.getTime();
                        this.lastModifiedDate = date;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.lastModified;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
        this.lastModifiedDate = null;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, new Date(l));
        }
    }

    public Date getLastModifiedDate() {
        Attribute attribute;
        if (this.lastModifiedDate != null) {
            return this.lastModifiedDate;
        }
        if (this.lastModified != -1L) {
            this.lastModifiedDate = new Date(this.lastModified);
            return this.lastModifiedDate;
        }
        if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
            try {
                Object object = attribute.get();
                if (object instanceof Long) {
                    this.lastModified = (Long)object;
                    this.lastModifiedDate = new Date(this.lastModified);
                } else if (object instanceof Date) {
                    this.lastModified = ((Date)object).getTime();
                    this.lastModifiedDate = (Date)object;
                } else {
                    String string = object.toString();
                    Date date = null;
                    for (int i = 0; date == null && i < concurrentFormats.length; ++i) {
                        try {
                            date = concurrentFormats[i].parse(string);
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (date != null) {
                        this.lastModified = date.getTime();
                        this.lastModifiedDate = date;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.lastModifiedDate;
    }

    @Deprecated
    public void setLastModifiedDate(Date date) {
        this.lastModified = date.getTime();
        this.lastModifiedDate = date;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, date);
        }
    }

    public String getLastModifiedHttp() {
        if (this.lastModifiedHttp != null) {
            return this.lastModifiedHttp;
        }
        Date date = this.getLastModifiedDate();
        if (date == null) {
            date = this.getCreationDate();
        }
        if (date == null) {
            date = new Date();
        }
        this.lastModifiedHttp = ConcurrentDateFormat.formatRfc1123(date);
        return this.lastModifiedHttp;
    }

    @Deprecated
    public void setLastModifiedHttp(String string) {
        this.lastModifiedHttp = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getName() {
        Attribute attribute;
        if (this.name != null) {
            return this.name;
        }
        if (this.attributes != null && (attribute = this.attributes.get(NAME)) != null) {
            try {
                this.name = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        if (this.attributes != null) {
            this.attributes.put(NAME, string);
        }
    }

    public String getResourceType() {
        Attribute attribute;
        String string = null;
        if (this.attributes != null && (attribute = this.attributes.get(TYPE)) != null) {
            try {
                string = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (string == null && this.collection) {
            string = COLLECTION_TYPE;
        }
        return string;
    }

    public void setResourceType(String string) {
        this.collection = string.equals(COLLECTION_TYPE);
        if (this.attributes != null) {
            this.attributes.put(TYPE, string);
        }
    }

    public String getETag() {
        Attribute attribute;
        String string = null;
        if (this.attributes != null && (attribute = this.attributes.get(ETAG)) != null) {
            try {
                string = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (string == null) {
            if (this.strongETag != null) {
                string = this.strongETag;
            } else {
                if (this.weakETag == null) {
                    long l = this.getContentLength();
                    long l2 = this.getLastModified();
                    if (l >= 0L || l2 >= 0L) {
                        this.weakETag = "W/\"" + l + "-" + l2 + "\"";
                    }
                }
                string = this.weakETag;
            }
        }
        return string;
    }

    public void setETag(String string) {
        this.strongETag = string;
        if (this.attributes != null) {
            this.attributes.put(ETAG, string);
        }
    }

    public String getCanonicalPath() {
        return null;
    }

    @Override
    public Attribute get(String string) {
        if (this.attributes == null) {
            if (string.equals(CREATION_DATE)) {
                Date date = this.getCreationDate();
                if (date == null) {
                    return null;
                }
                return new BasicAttribute(CREATION_DATE, date);
            }
            if (string.equals(ALTERNATE_CREATION_DATE)) {
                Date date = this.getCreationDate();
                if (date == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_CREATION_DATE, date);
            }
            if (string.equals(LAST_MODIFIED)) {
                Date date = this.getLastModifiedDate();
                if (date == null) {
                    return null;
                }
                return new BasicAttribute(LAST_MODIFIED, date);
            }
            if (string.equals(ALTERNATE_LAST_MODIFIED)) {
                Date date = this.getLastModifiedDate();
                if (date == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_LAST_MODIFIED, date);
            }
            if (string.equals(NAME)) {
                String string2 = this.getName();
                if (string2 == null) {
                    return null;
                }
                return new BasicAttribute(NAME, string2);
            }
            if (string.equals(TYPE)) {
                String string3 = this.getResourceType();
                if (string3 == null) {
                    return null;
                }
                return new BasicAttribute(TYPE, string3);
            }
            if (string.equals(ALTERNATE_TYPE)) {
                String string4 = this.getResourceType();
                if (string4 == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_TYPE, string4);
            }
            if (string.equals(CONTENT_LENGTH)) {
                long l = this.getContentLength();
                if (l < 0L) {
                    return null;
                }
                return new BasicAttribute(CONTENT_LENGTH, l);
            }
            if (string.equals(ALTERNATE_CONTENT_LENGTH)) {
                long l = this.getContentLength();
                if (l < 0L) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_CONTENT_LENGTH, l);
            }
            if (string.equals(ETAG)) {
                String string5 = this.getETag();
                if (string5 == null) {
                    return null;
                }
                return new BasicAttribute(ETAG, string5);
            }
            if (string.equals(ALTERNATE_ETAG)) {
                String string6 = this.getETag();
                if (string6 == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_ETAG, string6);
            }
        } else {
            return this.attributes.get(string);
        }
        return null;
    }

    @Override
    public Attribute put(Attribute attribute) {
        if (this.attributes == null) {
            try {
                return this.put(attribute.getID(), attribute.get());
            }
            catch (NamingException namingException) {
                return null;
            }
        }
        return this.attributes.put(attribute);
    }

    @Override
    public Attribute put(String string, Object object) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.put(string, object);
    }

    @Override
    public Attribute remove(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(string);
    }

    @Override
    public NamingEnumeration<? extends Attribute> getAll() {
        if (this.attributes == null) {
            Object object;
            long l;
            String string;
            String string2;
            Date date;
            Vector<BasicAttribute> vector = new Vector<BasicAttribute>();
            Date date2 = this.getCreationDate();
            if (date2 != null) {
                vector.addElement(new BasicAttribute(CREATION_DATE, date2));
                vector.addElement(new BasicAttribute(ALTERNATE_CREATION_DATE, date2));
            }
            if ((date = this.getLastModifiedDate()) != null) {
                vector.addElement(new BasicAttribute(LAST_MODIFIED, date));
                vector.addElement(new BasicAttribute(ALTERNATE_LAST_MODIFIED, date));
            }
            if ((string2 = this.getName()) != null) {
                vector.addElement(new BasicAttribute(NAME, string2));
            }
            if ((string = this.getResourceType()) != null) {
                vector.addElement(new BasicAttribute(TYPE, string));
                vector.addElement(new BasicAttribute(ALTERNATE_TYPE, string));
            }
            if ((l = this.getContentLength()) >= 0L) {
                object = l;
                vector.addElement(new BasicAttribute(CONTENT_LENGTH, object));
                vector.addElement(new BasicAttribute(ALTERNATE_CONTENT_LENGTH, object));
            }
            if ((object = this.getETag()) != null) {
                vector.addElement(new BasicAttribute(ETAG, object));
                vector.addElement(new BasicAttribute(ALTERNATE_ETAG, object));
            }
            return new RecyclableNamingEnumeration(vector);
        }
        return this.attributes.getAll();
    }

    @Override
    public NamingEnumeration<String> getIDs() {
        if (this.attributes == null) {
            String string;
            long l;
            String string2;
            Date date;
            Vector<String> vector = new Vector<String>();
            Date date2 = this.getCreationDate();
            if (date2 != null) {
                vector.addElement(CREATION_DATE);
                vector.addElement(ALTERNATE_CREATION_DATE);
            }
            if ((date = this.getLastModifiedDate()) != null) {
                vector.addElement(LAST_MODIFIED);
                vector.addElement(ALTERNATE_LAST_MODIFIED);
            }
            if (this.getName() != null) {
                vector.addElement(NAME);
            }
            if ((string2 = this.getResourceType()) != null) {
                vector.addElement(TYPE);
                vector.addElement(ALTERNATE_TYPE);
            }
            if ((l = this.getContentLength()) >= 0L) {
                vector.addElement(CONTENT_LENGTH);
                vector.addElement(ALTERNATE_CONTENT_LENGTH);
            }
            if ((string = this.getETag()) != null) {
                vector.addElement(ETAG);
                vector.addElement(ALTERNATE_ETAG);
            }
            return new RecyclableNamingEnumeration<String>(vector);
        }
        return this.attributes.getIDs();
    }

    @Override
    public int size() {
        if (this.attributes == null) {
            int n = 0;
            if (this.getCreationDate() != null) {
                n += 2;
            }
            if (this.getLastModifiedDate() != null) {
                n += 2;
            }
            if (this.getName() != null) {
                ++n;
            }
            if (this.getResourceType() != null) {
                n += 2;
            }
            if (this.getContentLength() >= 0L) {
                n += 2;
            }
            if (this.getETag() != null) {
                n += 2;
            }
            return n;
        }
        return this.attributes.size();
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public boolean isCaseIgnored() {
        return false;
    }

    static {
        format.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
    }
}

