/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileExtrasLkp;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class FileSystem
implements Serializable {
    static final Logger LOG = Logger.getLogger(FileSystem.class.getName());
    private static final long serialVersionUID = -8931487924240189180L;
    public static final String PROP_VALID = "valid";
    @Deprecated
    public static final String PROP_HIDDEN = "hidden";
    @Deprecated
    public static final String PROP_SYSTEM_NAME = "systemName";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ROOT = "root";
    public static final String PROP_READ_ONLY = "readOnly";
    private static final Object internLock = new Object();
    private static transient ThreadLocal<EventControl> thrLocal = new ThreadLocal();
    private static final StatusDecorator STATUS_NONE = new StatusDecorator(){

        @Override
        public String annotateName(String string, Set<? extends FileObject> set) {
            return string;
        }

        @Override
        public String annotateNameHtml(String string, Set<? extends FileObject> set) {
            return null;
        }
    };
    private transient boolean valid = false;
    transient boolean assigned = false;
    private transient Repository repository = null;
    private transient FCLSupport fclSupport;
    private String systemName = "";
    private transient ListenerList<FileStatusListener> fileStatusList;
    private transient ListenerList<VetoableChangeListener> vetoableChangeList;
    private transient PropertyChangeSupport changeSupport;
    private volatile Boolean defFS;
    private static volatile Lookup.Result<StatusDecorator> statusResult;
    private static StatusDecorator SFS_STATUS;

    public void refresh(boolean bl) {
    }

    public final boolean isValid() {
        return this.valid;
    }

    final void setValid(boolean bl) {
        if (bl != this.valid) {
            this.valid = bl;
            this.firePropertyChange(PROP_VALID, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE, Boolean.FALSE);
        }
    }

    public abstract String getDisplayName();

    @Deprecated
    public final String getSystemName() {
        return this.systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected final void setSystemName(String string) throws PropertyVetoException {
        String string2 = PROP_SYSTEM_NAME;
        synchronized (PROP_SYSTEM_NAME) {
            if (this.systemName.equals(string)) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            this.fireVetoableChange(PROP_SYSTEM_NAME, this.systemName, string);
            String string3 = this.systemName;
            String string4 = this.systemName = string.intern();
            // ** MonitorExit[var4_2] (shouldn't be in output)
            this.firePropertyChange(PROP_SYSTEM_NAME, string3, string4);
            this.firePropertyChange(PROP_DISPLAY_NAME, null, null);
            return;
        }
    }

    public final boolean isDefault() {
        boolean bl = false;
        if (this.defFS != null && !bl) {
            return this.defFS;
        }
        FileSystem fileSystem = null;
        try {
            fileSystem = FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        if (this.defFS != null) {
            // empty if block
        }
        this.defFS = this == fileSystem;
        return this.defFS;
    }

    public abstract boolean isReadOnly();

    public abstract FileObject getRoot();

    @Deprecated
    public FileObject find(String string, String string2, String string3) {
        assert (false) : "Deprecated.";
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.equals("")) {
            String string4 = string.replace('.', '/');
            stringBuffer.append(string4);
            stringBuffer.append('/');
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        return this.findResource(stringBuffer.toString());
    }

    public abstract FileObject findResource(String var1);

    public FileObject getTempFolder() throws IOException {
        throw new IOException("Unsupported operation");
    }

    public FileObject createTempFile(FileObject fileObject, String string, String string2, boolean bl) throws IOException {
        throw new IOException("Unsupported operation");
    }

    public Lookup findExtrasFor(Set<FileObject> set) {
        return new FileExtrasLkp(this, set);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public String toString() {
        return this.getSystemName() + "[" + super.toString() + "]";
    }

    private static StatusDecorator defaultStatus() {
        Iterator iterator;
        if (statusResult == null) {
            statusResult = Lookup.getDefault().lookupResult(StatusDecorator.class);
        }
        return (iterator = statusResult.allInstances().iterator()).hasNext() ? (StatusDecorator)iterator.next() : SFS_STATUS;
    }

    public StatusDecorator getDecorator() {
        return this.isDefault() ? FileSystem.defaultStatus() : STATUS_NONE;
    }

    public final void runAtomicAction(AtomicAction atomicAction) throws IOException {
        this.getEventControl().runAtomicAction(atomicAction);
    }

    void beginAtomicAction(AtomicAction atomicAction) {
        this.getEventControl().beginAtomicAction(atomicAction);
    }

    void beginAtomicAction() {
        this.beginAtomicAction(null);
    }

    void finishAtomicAction() {
        this.getEventControl().finishAtomicAction();
    }

    void dispatchEvent(EventDispatcher eventDispatcher) {
        this.getEventControl().dispatchEvent(eventDispatcher);
    }

    private final EventControl getEventControl() {
        EventControl eventControl = thrLocal.get();
        if (eventControl == null) {
            eventControl = new EventControl();
            thrLocal.set(eventControl);
        }
        return eventControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileStatusListener(FileStatusListener fileStatusListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.getDecorator() == STATUS_NONE) {
                return;
            }
            if (this.fileStatusList == null) {
                this.fileStatusList = new ListenerList();
            }
            this.fileStatusList.add(fileStatusListener);
        }
    }

    public final void removeFileStatusListener(FileStatusListener fileStatusListener) {
        if (this.fileStatusList == null) {
            return;
        }
        this.fileStatusList.remove(fileStatusListener);
    }

    protected final void fireFileStatusChanged(FileStatusEvent fileStatusEvent) {
        if (this.fileStatusList == null) {
            return;
        }
        List<FileStatusListener> list = this.fileStatusList.getAllListeners();
        this.dispatchEvent(new FileStatusDispatcher(list, fileStatusEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.vetoableChangeList == null) {
                this.vetoableChangeList = new ListenerList();
            }
            this.vetoableChangeList.add(vetoableChangeListener);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeList == null) {
            return;
        }
        this.vetoableChangeList.remove(vetoableChangeListener);
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeList == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        for (VetoableChangeListener vetoableChangeListener : this.vetoableChangeList.getAllListeners()) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            }
            vetoableChangeListener.vetoableChange(propertyChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = internLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2, null);
    }

    final void firePropertyChange(String string, Object object, Object object2, Object object3) {
        if (this.changeSupport == null) {
            return;
        }
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        propertyChangeEvent.setPropagationId(object3);
        this.changeSupport.firePropertyChange(propertyChangeEvent);
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    final Repository getRepository() {
        return this.repository;
    }

    void setRepository(Repository repository) {
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class<FCLSupport> clazz = FCLSupport.class;
        synchronized (FCLSupport.class) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fclSupport;
        }
    }

    public final void addFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().addFileChangeListener(fileChangeListener);
    }

    public final void removeFileChangeListener(FileChangeListener fileChangeListener) {
        this.getFCLSupport().removeFileChangeListener(fileChangeListener);
    }

    void waitRefreshed() {
    }

    static {
        SFS_STATUS = new StatusDecorator(){

            @Override
            public String annotateNameHtml(String string, Set<? extends FileObject> set) {
                return null;
            }

            @Override
            public String annotateName(String string, Set<? extends FileObject> set) {
                for (FileObject fileObject : set) {
                    String string2 = this.annotateName(fileObject);
                    if (string2 == null) continue;
                    return string2;
                }
                return string;
            }

            private final String annotateName(FileObject fileObject) {
                String string = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
                if (string != null) {
                    try {
                        string = BaseUtilities.translate((String)string);
                        ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
                        try {
                            return resourceBundle.getString(fileObject.getPath());
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        Exceptions.attachMessage((Throwable)missingResourceException, (String)this.warningMessage(string, fileObject));
                        LOG.log(Level.INFO, null, missingResourceException);
                    }
                }
                return (String)fileObject.getAttribute(FileSystem.PROP_DISPLAY_NAME);
            }

            private String warningMessage(String string, FileObject fileObject) {
                Object object = fileObject.getAttribute("layers");
                if (object instanceof Object[]) {
                    object = Arrays.toString((Object[])object);
                }
                return "Cannot load " + string + " for " + fileObject + " defined by " + object;
            }
        };
    }

    private static class FileStatusDispatcher
    extends EventDispatcher {
        private List<FileStatusListener> listeners;
        private FileStatusEvent fStatusEvent;

        public FileStatusDispatcher(List<FileStatusListener> list, FileStatusEvent fileStatusEvent) {
            this.listeners = list;
            this.fStatusEvent = fileStatusEvent;
        }

        @Override
        protected void dispatch(boolean bl, Collection<Runnable> collection) {
            if (bl) {
                return;
            }
            for (FileStatusListener fileStatusListener : this.listeners) {
                fileStatusListener.annotationChanged(this.fStatusEvent);
            }
        }

        @Override
        protected void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
        }
    }

    static abstract class EventDispatcher
    implements Runnable {
        EventDispatcher() {
        }

        @Override
        public final void run() {
            this.dispatch(false, null);
        }

        protected abstract void dispatch(boolean var1, Collection<Runnable> var2);

        protected abstract void setAtomicActionLink(EventControl.AtomicActionLink var1);
    }

    static interface AsyncAtomicAction
    extends AtomicAction {
        public boolean isAsynchronous();
    }

    public static interface AtomicAction {
        public void run() throws IOException;
    }
}

