/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import org.netbeans.lib.profiler.charts.ChartItemListener;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;

public abstract class SynchronousXYItem
implements XYItem {
    private final String name;
    private Timeline timeline;
    private int lastIndex;
    private final LongRect bounds;
    private long initialMinY;
    private long initialMaxY;
    private LongRect initialBounds;
    private long minY;
    private long maxY;

    public SynchronousXYItem(String string) {
        this(string, Long.MAX_VALUE);
    }

    public SynchronousXYItem(String string, long l) {
        this(string, l, Long.MIN_VALUE);
    }

    public SynchronousXYItem(String string, long l, long l2) {
        this.name = string;
        this.initialMinY = l;
        this.initialMaxY = l2;
        this.minY = Long.MAX_VALUE;
        this.maxY = Long.MIN_VALUE;
        this.bounds = new LongRect();
        this.initialBounds = new LongRect();
        this.lastIndex = -1;
    }

    public String getName() {
        return this.name;
    }

    public void setInitialBounds(LongRect longRect) {
        this.initialBounds = longRect;
    }

    public LongRect getInitialBounds() {
        return this.initialBounds;
    }

    public XYItemChange valuesChanged() {
        int n = this.timeline.getTimestampsCount() - 1;
        XYItemChange.Default default_ = null;
        if (this.lastIndex == n) {
            LongRect longRect = new LongRect(this.bounds);
            default_ = new XYItemChange.Default(this, new int[]{-1}, longRect, longRect, longRect);
        } else if (n > -1) {
            int n2;
            int n3;
            LongRect longRect = new LongRect(this.bounds);
            LongRect longRect2 = new LongRect();
            boolean bl = this.lastIndex == -1;
            for (n3 = n2 = this.lastIndex == -1 ? 0 : this.lastIndex; n3 <= n; ++n3) {
                long l = this.timeline.getTimestamp(n3);
                long l2 = this.getYValue(n3);
                this.minY = Math.min(l2, this.minY);
                this.maxY = Math.max(l2, this.maxY);
                if (bl) {
                    this.bounds.x = l;
                    this.bounds.y = Math.min(l2, this.initialMinY);
                    this.bounds.width = 0L;
                    this.bounds.height = Math.max(l2, this.initialMaxY) - this.bounds.y;
                    bl = false;
                } else {
                    LongRect.add(this.bounds, l, l2);
                }
                if (n3 == n2) {
                    longRect2.x = l;
                    longRect2.y = l2;
                    longRect2.width = this.timeline.getTimestamp(n) - longRect2.x;
                    continue;
                }
                long l3 = longRect2.y;
                longRect2.y = Math.min(l3, l2);
                longRect2.height = Math.max(l3, l2) - longRect2.y;
            }
            n3 = n - this.lastIndex;
            int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = this.lastIndex + 1 + i;
            }
            default_ = new XYItemChange.Default(this, nArray, longRect, new LongRect(this.bounds), longRect2);
        } else {
            this.minY = Long.MAX_VALUE;
            this.maxY = Long.MIN_VALUE;
            LongRect longRect = new LongRect(this.bounds);
            LongRect.set(this.bounds, 0L, 0L, 0L, 0L);
            default_ = new XYItemChange.Default(this, new int[]{-1}, longRect, new LongRect(this.bounds), longRect);
        }
        this.lastIndex = n;
        return default_;
    }

    @Override
    public int getValuesCount() {
        return this.timeline.getTimestampsCount();
    }

    @Override
    public long getXValue(int n) {
        return this.timeline.getTimestamp(n);
    }

    @Override
    public abstract long getYValue(int var1);

    public long getMinYValue() {
        return this.minY;
    }

    public long getMaxYValue() {
        return this.maxY;
    }

    @Override
    public LongRect getBounds() {
        if (this.getValuesCount() == 0) {
            return this.initialBounds;
        }
        return this.bounds;
    }

    @Override
    public void addItemListener(ChartItemListener chartItemListener) {
    }

    @Override
    public void removeItemListener(ChartItemListener chartItemListener) {
    }

    void setTimeline(Timeline timeline) {
        this.timeline = timeline;
    }
}

