/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.ui;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.swing.HTMLTextComponent;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerNodeAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class HTMLView {
    private final String viewID;
    private final HeapContext context;
    private final HeapViewerActions actions;
    private Collection<HeapViewerNodeAction.Provider> actionProviders;
    private JComponent component;
    private HTMLTextComponent htmlComponent;
    private String currentText;
    private boolean pendingText = true;
    private String pendingReference;

    public HTMLView(String viewID, HeapContext context, HeapViewerActions actions) {
        this(viewID, context, actions, null);
    }

    public HTMLView(String viewID, HeapContext context, HeapViewerActions actions, String initialText) {
        this.viewID = viewID;
        this.context = context;
        this.actions = actions;
        this.currentText = initialText;
        this.actionProviders = new ArrayList<HeapViewerNodeAction.Provider>();
        for (HeapViewerNodeAction.Provider provider : Lookup.getDefault().lookupAll(HeapViewerNodeAction.Provider.class)) {
            if (!provider.supportsView(context, viewID)) continue;
            this.actionProviders.add(provider);
        }
    }

    protected String computeData(HeapContext context, String viewID) {
        return this.currentText;
    }

    protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
        return null;
    }

    public void setText(String text) {
        this.currentText = text;
        if (this.htmlComponent != null) {
            this.htmlComponent.setText(this.currentText);
            String _text = this.htmlComponent.getText();
            if (_text != null && _text.length() > 0) {
                try {
                    this.htmlComponent.setCaretPosition(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void selectReference(String reference) {
        if (this.htmlComponent == null || this.pendingText) {
            this.pendingReference = reference;
        } else {
            this.pendingReference = null;
            Document d = this.htmlComponent.getDocument();
            if (d instanceof HTMLDocument) {
                HTMLDocument doc = (HTMLDocument)d;
                HTMLDocument.Iterator iter = doc.getIterator(HTML.Tag.A);
                while (iter.isValid()) {
                    AttributeSet a = iter.getAttributes();
                    String nm = (String)a.getAttribute(HTML.Attribute.NAME);
                    if (Objects.equals(reference, nm)) {
                        this.selectReference(iter);
                        return;
                    }
                    iter.next();
                }
            }
        }
    }

    private void selectReference(HTMLDocument.Iterator iter) {
        try {
            this.htmlComponent.requestFocusInWindow();
            int start = iter.getStartOffset();
            Rectangle rect = this.htmlComponent.modelToView(start);
            if (rect != null) {
                rect.height = this.htmlComponent.getVisibleRect().height;
                this.htmlComponent.scrollRectToVisible(rect);
            }
            this.htmlComponent.select(start, iter.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.initUI();
        }
        return this.component;
    }

    String getViewID() {
        return this.viewID;
    }

    HeapContext getContext() {
        return this.context;
    }

    private void initUI() {
        this.htmlComponent = new HTMLTextComponent(){

            @Override
            protected void firstDisplayed() {
                super.firstDisplayed();
                HTMLView.this.htmlComponent.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        URL link;
                        if (SwingUtilities.isMiddleMouseButton(e) && (link = HTMLView.this.htmlComponent.getActiveLink()) != null) {
                            HTMLView.this.invokeMiddleButtonAction(link, e);
                        }
                    }
                });
                new SwingWorker<String, String>(){

                    @Override
                    protected String doInBackground() throws Exception {
                        return HTMLView.this.computeData(HTMLView.this.context, HTMLView.this.viewID);
                    }

                    @Override
                    protected void done() {
                        try {
                            HTMLView.this.setText((String)this.get());
                            HTMLView.this.pendingText = false;
                            if (HTMLView.this.pendingReference != null) {
                                HTMLView.this.selectReference(HTMLView.this.pendingReference);
                            }
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }.execute();
            }

            protected void showURL(URL url, InputEvent e) {
                HTMLView.this.invokeDefaultAction(url, e);
            }

            protected void populatePopup(JPopupMenu popup) {
                URL link = HTMLView.this.htmlComponent.getActiveLink();
                if (link != null) {
                    HTMLView.this.populatePopup(link, popup);
                }
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(this.createCopyMenuItem());
                popup.add(this.createSelectAllMenuItem());
            }
        };
        if (this.currentText != null) {
            this.htmlComponent.setText(this.currentText);
        }
        this.component = new JPanel(new BorderLayout());
        this.component.add((Component)((Object)this.htmlComponent), "Center");
    }

    private void invokeDefaultAction(URL url, InputEvent e) {
        HeapViewerNode node = this.nodeForURL(url, this.context);
        if (node == null) {
            return;
        }
        HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, this.actionProviders, this.context, this.actions, new HeapViewerNodeAction[0]);
        ActionEvent ae = e == null ? new ActionEvent((Object)this.htmlComponent, 1001, "link") : new ActionEvent(e.getSource(), e.getID(), "link", e.getWhen(), e.getModifiers());
        nodeActions.performDefaultAction(ae);
    }

    private void invokeMiddleButtonAction(URL url, InputEvent e) {
        HeapViewerNode node = this.nodeForURL(url, this.context);
        if (node == null) {
            return;
        }
        HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, this.actionProviders, this.context, this.actions, new HeapViewerNodeAction[0]);
        ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
        nodeActions.performMiddleButtonAction(ae);
    }

    private void populatePopup(URL url, JPopupMenu popup) {
        HeapViewerNode node = this.nodeForURL(url, this.context);
        if (node == null) {
            return;
        }
        HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(node, this.actionProviders, this.context, this.actions, new HeapViewerNodeAction[0]);
        nodeActions.populatePopup(popup);
    }
}

