/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.utils.Wildcards;

class RootMethods {
    String[] classNames;
    boolean[] classesWildcard;
    boolean[] markerMethods;
    String[] methodNames;
    String[] methodSignatures;

    RootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.classNames = new String[sourceCodeSelectionArray.length];
        this.methodNames = new String[sourceCodeSelectionArray.length];
        this.methodSignatures = new String[sourceCodeSelectionArray.length];
        this.classesWildcard = new boolean[sourceCodeSelectionArray.length];
        this.markerMethods = new boolean[sourceCodeSelectionArray.length];
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = sourceCodeSelectionArray[i];
            if (sourceCodeSelection.definedViaSourceLines()) {
                this.classNames = new String[]{sourceCodeSelection.getClassName()};
            } else if (sourceCodeSelection.definedViaMethodName()) {
                this.classNames[i] = sourceCodeSelection.getClassName().replace('.', '/').intern();
                String string = this.classNames[i];
                if (Wildcards.isPackageWildcard(string)) {
                    this.classesWildcard[i] = true;
                    this.classNames[i] = Wildcards.unwildPackage(string);
                } else {
                    this.methodNames[i] = sourceCodeSelection.getMethodName().intern();
                    this.methodSignatures[i] = sourceCodeSelection.getMethodSignature().intern();
                    this.classesWildcard[i] = false;
                }
            } else {
                this.methodSignatures = new String[0];
                this.methodNames = this.methodSignatures;
                this.classNames = this.methodSignatures;
            }
            this.markerMethods[i] = sourceCodeSelection.isMarkerMethod();
        }
    }

    List getRootClassNames() {
        if (this.classNames.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.classNames.length; ++i) {
                String string = this.classNames[i].replace('/', '.');
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            return arrayList;
        }
        return null;
    }
}

