/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.HeapHistogram;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;

public class SampledMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_SAMPLED_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("SampledMemoryResultsSnapshot_MemorySamledMsg");
    private int[] liveObjectsCounts;

    public SampledMemoryResultsSnapshot() {
    }

    public SampledMemoryResultsSnapshot(long l, long l2, ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        super(l, l2, null, profilerClient);
    }

    public int[] getObjectsCounts() {
        return this.liveObjectsCounts;
    }

    @Override
    public void performInit(ProfilerClient profilerClient, MemoryCCTProvider memoryCCTProvider) throws ClientUtils.TargetAppOrVMTerminated {
        HeapHistogram heapHistogram = profilerClient.getHeapHistogram();
        Set<HeapHistogram.ClassInfo> set = heapHistogram.getHeapHistogram();
        this.nProfiledClasses = set.size();
        this.classNames = new String[this.nProfiledClasses];
        this.objectsSizePerClass = new long[this.nProfiledClasses];
        this.liveObjectsCounts = new int[this.nProfiledClasses];
        int n = 0;
        for (HeapHistogram.ClassInfo classInfo : set) {
            this.classNames[n] = classInfo.getName();
            this.objectsSizePerClass[n] = classInfo.getBytes();
            this.liveObjectsCounts[n] = (int)classInfo.getInstancesCount();
            ++n;
        }
    }

    @Override
    public SampledMemoryResultsSnapshot createDiff(MemoryResultsSnapshot memoryResultsSnapshot) {
        if (!(memoryResultsSnapshot instanceof SampledMemoryResultsSnapshot)) {
            return null;
        }
        return new SampledMemoryResultsDiff(this, (SampledMemoryResultsSnapshot)memoryResultsSnapshot);
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        super.readFromStream(dataInputStream);
        int n = dataInputStream.readInt();
        this.liveObjectsCounts = new int[n];
        for (int i = 0; i < n; ++i) {
            this.liveObjectsCounts[i] = dataInputStream.readInt();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_SAMPLED_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.liveObjectsCounts.length);
        for (int i = 0; i < this.liveObjectsCounts.length; ++i) {
            dataOutputStream.writeInt(this.liveObjectsCounts[i]);
        }
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, boolean bl) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this.getJMethodIdTable(), runtimeMemoryCCTNode, this.getClassName(n));
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.finest("objectsCounts.length: " + this.debugLength(this.liveObjectsCounts));
    }
}

