/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.ui.swing.renderer.BaseRenderer;
import org.netbeans.lib.profiler.ui.threads.ViewManager;

public class TimelineRenderer
extends BaseRenderer {
    private static final Color TICK_COLOR = new Color(200, 200, 200);
    private static final int BAR_MARGIN = 3;
    private static final int BAR_MARGIN_X2 = 6;
    private final ViewManager view;
    private ViewManager.RowView rowView;

    private static ResourceBundle BUNDLE() {
        return ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    }

    public TimelineRenderer(ViewManager viewManager) {
        this.view = viewManager;
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
        this.putClientProperty("ProfilerTableHover_NoHover", this);
    }

    @Override
    public void setValue(Object object, int n) {
        this.rowView = (ViewManager.RowView)object;
    }

    @Override
    public String toString() {
        int n = this.rowView == null ? -1 : this.rowView.getLastIndex();
        return TimelineRenderer.getStateName(n == -1 ? -1 : this.rowView.getState(n));
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        int n2 = this.size.width;
        int n3 = this.size.height;
        long l = this.view.getFirstTimeMark(false);
        long l2 = this.view.getTimeMarksStep();
        graphics.setColor(TICK_COLOR);
        int n4 = n = this.view.getTimePosition(l, false);
        while (n < n2) {
            graphics.drawLine(n + this.location.x, this.location.y, n + this.location.x, n3 - 1 + this.location.y);
            n = this.view.getTimePosition(l += l2, false);
            if (n <= n4) break;
            n4 = n;
        }
        if (this.rowView == null) {
            return;
        }
        int n5 = this.rowView.getLastIndex();
        if (n5 == -1) {
            return;
        }
        int n6 = (n5 == this.rowView.getMaxIndex() ? this.rowView.getMaxPosition() : this.rowView.getPosition(this.rowView.getTime(n5 + 1))) + this.location.x;
        while (n5 >= 0 && n6 >= 0) {
            n = Math.max(0, this.rowView.getPosition(this.rowView.getTime(n5))) + this.location.x;
            int n7 = n6 - n;
            if (n7 > 0) {
                Color color = ThreadData.getThreadStateColor((int)this.rowView.getState(n5));
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(n, 3 + this.location.y, n7, n3 - 6);
                }
                n6 = n;
            }
            --n5;
        }
    }

    private static String getStateName(int n) {
        switch (n) {
            case 1: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateRunning");
            }
            case 2: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateSleeping");
            }
            case 3: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateMonitor");
            }
            case 4: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateWait");
            }
            case 5: {
                return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStatePark");
            }
        }
        return TimelineRenderer.BUNDLE().getString("TimelineRenderer_ThreadStateFinished");
    }
}

