/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.InstancesContainerNode;
import org.netbeans.modules.profiler.heapwalk.model.RootNode;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class BrowserUtils {
    public static final ImageIcon ICON_INSTANCE = Icons.getImageIcon((String)"LanguageIcons.Instance");
    public static final ImageIcon ICON_PRIMITIVE = Icons.getImageIcon((String)"LanguageIcons.Primitive");
    public static final ImageIcon ICON_ARRAY = Icons.getImageIcon((String)"LanguageIcons.Array");
    public static final ImageIcon ICON_PROGRESS = Icons.getImageIcon((String)"HeapWalkerIcons.Progress");
    public static final ImageIcon ICON_STATIC = Icons.getImageIcon((String)"HeapWalkerIcons.Static");
    public static final ImageIcon ICON_LOOP = Icons.getImageIcon((String)"HeapWalkerIcons.Loop");
    public static final ImageIcon ICON_GCROOT = Icons.getImageIcon((String)"HeapWalkerIcons.GcRoot");
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("HeapWalker Processor", 5, true);
    private static final int MAX_FULLNAME_LENGTH = 100;

    public static String getArrayItemType(String string) {
        int n = string.lastIndexOf(91);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getArrayBaseType(String string) {
        int n = string.indexOf(91);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String getFullNodeName(HeapWalkerNode heapWalkerNode) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!heapWalkerNode.isRoot()) {
            int n = stringBuilder.length();
            if (n < 100) {
                String string = BrowserUtils.getNodeName(heapWalkerNode);
                stringBuilder.insert(0, "." + string);
                heapWalkerNode = heapWalkerNode.getParent();
                continue;
            }
            stringBuilder.delete(0, Bundle.BrowserUtils_TruncatedMsg().length());
            stringBuilder.insert(0, Bundle.BrowserUtils_TruncatedMsg());
            break;
        }
        stringBuilder.insert(0, BrowserUtils.getNodeName(heapWalkerNode));
        return stringBuilder.toString();
    }

    public static GroupingInfo getGroupingInfo(int n) {
        int n2 = n;
        int n3 = 500;
        int n4 = (int)Math.ceil((float)n2 / (float)n3);
        while (n4 > 5000 && n3 < 5000) {
            n4 = (int)Math.ceil((float)n2 / (float)(n3 += 500));
        }
        return new GroupingInfo(n4, n3);
    }

    public static HeapWalkerNode getRoot(HeapWalkerNode heapWalkerNode) {
        while (heapWalkerNode != null && !heapWalkerNode.isRoot()) {
            heapWalkerNode = heapWalkerNode.getParent();
        }
        return heapWalkerNode == null ? null : heapWalkerNode;
    }

    public static String getSimpleType(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        if (string.startsWith("<")) {
            return "<" + string.substring(n + 1);
        }
        return string.substring(n + 1);
    }

    public static boolean isStaticField(FieldValue fieldValue) {
        return fieldValue.getField().isStatic();
    }

    public static TreePath ensurePathComputed(HeapWalkerNode heapWalkerNode, TreePath treePath, Set<HeapWalkerNode> set) {
        ArrayList<HeapWalkerNode> arrayList = new ArrayList<HeapWalkerNode>();
        Object[] objectArray = treePath.getPath();
        if (heapWalkerNode == null || !((Object)((Object)heapWalkerNode)).equals(objectArray[0])) {
            return null;
        }
        arrayList.add(heapWalkerNode);
        for (int i = 1; i <= objectArray.length; ++i) {
            HeapWalkerNode[] heapWalkerNodeArray = null;
            if (heapWalkerNode instanceof AbstractHeapWalkerNode && !set.contains((Object)heapWalkerNode)) {
                HeapWalkerNode[] heapWalkerNodeArray2 = (HeapWalkerNode[])heapWalkerNode;
                ChildrenComputer childrenComputer = heapWalkerNodeArray2.getChildrenComputer();
                if (childrenComputer != null) {
                    heapWalkerNodeArray = childrenComputer.computeChildren();
                }
                heapWalkerNodeArray2.setChildren(heapWalkerNodeArray);
                set.add(heapWalkerNode);
            }
            if (heapWalkerNodeArray == null) {
                heapWalkerNodeArray = heapWalkerNode.getChildren();
            }
            heapWalkerNode = null;
            if (i < objectArray.length) {
                for (HeapWalkerNode heapWalkerNode2 : heapWalkerNodeArray) {
                    if (!((Object)((Object)heapWalkerNode2)).equals(objectArray[i])) continue;
                    heapWalkerNode = heapWalkerNode2;
                    arrayList.add(heapWalkerNode);
                    break;
                }
            }
            if (heapWalkerNode == null) break;
        }
        return new TreePath(arrayList.toArray());
    }

    public static void restoreState(JTreeTable jTreeTable, List list, TreePath treePath) {
        if (list != null) {
            JTree jTree = jTreeTable.getTree();
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)((Object)jTree.getModel().getRoot());
            for (Object e : list) {
                BrowserUtils.ensurePathComputed(heapWalkerNode, (TreePath)e, new HashSet<HeapWalkerNode>());
            }
            jTreeTable.setup(list, treePath);
        }
    }

    public static HeapWalkerNode computeChildrenToNearestGCRoot(InstanceNode instanceNode) {
        HeapWalkerNode heapWalkerNode = instanceNode;
        Instance instance = instanceNode.getInstance();
        Instance instance2 = instance.getNearestGCRootPointer();
        HeapWalkerNode[] heapWalkerNodeArray = null;
        while (!instance.equals(instance2)) {
            if (instance2 == null || heapWalkerNode == null) {
                heapWalkerNode = null;
                break;
            }
            if (heapWalkerNodeArray == null) {
                if (heapWalkerNode instanceof InstanceNode && !heapWalkerNode.currentlyHasChildren()) {
                    InstanceNode instanceNode2 = heapWalkerNode;
                    heapWalkerNodeArray = instanceNode2.getChildrenComputer().computeChildren();
                    instanceNode2.setChildren(heapWalkerNodeArray);
                } else {
                    heapWalkerNodeArray = ((HeapWalkerNode)heapWalkerNode).getChildren();
                }
            }
            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                HeapWalkerNode heapWalkerNode2 = heapWalkerNodeArray[i];
                if (heapWalkerNode2 instanceof InstanceNode) {
                    if (!((InstanceNode)heapWalkerNode2).getInstance().equals(instance2)) continue;
                    heapWalkerNode = heapWalkerNode2;
                    heapWalkerNodeArray = null;
                    break;
                }
                if (!(heapWalkerNode2 instanceof InstancesContainerNode) || !((InstancesContainerNode)heapWalkerNode2).getInstances().contains(instance2)) continue;
                heapWalkerNode = heapWalkerNode2;
                heapWalkerNodeArray = null;
                break;
            }
            instance = instance2;
            instance2 = instance2.getNearestGCRootPointer();
        }
        return heapWalkerNode;
    }

    public static ImageIcon createGCRootIcon(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_GCROOT.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createLoopIcon(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_LOOP.getImage(), (int)0, (int)0));
    }

    public static ImageIcon createStaticIcon(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ICON_STATIC.getImage(), (int)0, (int)0));
    }

    public static HeapWalkerNode[] lazilyCreateChildren(final HeapWalkerNode heapWalkerNode, final ChildrenComputer childrenComputer) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserUtils.performTask(new Runnable(){

                    @Override
                    public void run() {
                        if (heapWalkerNode instanceof AbstractHeapWalkerNode) {
                            HeapWalkerNode[] heapWalkerNodeArray;
                            boolean bl = false;
                            try {
                                heapWalkerNodeArray = childrenComputer.computeChildren();
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                                bl = true;
                                heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createOOMNode(heapWalkerNode)};
                            }
                            final HeapWalkerNode[] heapWalkerNodeArray2 = heapWalkerNodeArray;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((AbstractHeapWalkerNode)heapWalkerNode).changeChildren(heapWalkerNodeArray2);
                                    HeapWalkerNode heapWalkerNode = BrowserUtils.getRoot(heapWalkerNode);
                                    if (heapWalkerNode instanceof RootNode) {
                                        ((RootNode)((Object)heapWalkerNode)).refreshView();
                                    }
                                }
                            });
                            if (bl) {
                                ProfilerDialogs.displayError((String)Bundle.BrowserUtils_OutOfMemoryMsg());
                            }
                        }
                    }
                });
            }
        });
        return new HeapWalkerNode[]{HeapWalkerNodeFactory.createProgressNode(heapWalkerNode)};
    }

    public static void copyPathFromRoot(final TreePath treePath) {
        BrowserUtils.performTask(new Runnable(){

            @Override
            public void run() {
                StringSelection stringSelection = new StringSelection(BrowserUtils.pathFromRoot(treePath));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                ProfilerDialogs.displayInfo((String)Bundle.BrowserUtils_PathCopiedToClipboard());
            }
        });
    }

    private static String pathFromRoot(TreePath treePath) {
        int n = ((HeapWalkerNode)((Object)treePath.getLastPathComponent())).getMode();
        Object[] objectArray = treePath.getPath();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            HeapWalkerNode heapWalkerNode = (HeapWalkerNode)((Object)objectArray[i]);
            if (n == 1) {
                BrowserUtils.fieldFromRoot(heapWalkerNode, stringBuilder, i, n2);
            } else {
                BrowserUtils.referenceFromRoot(heapWalkerNode, stringBuilder, i, n2);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString().replace("].[", "");
    }

    private static void fieldFromRoot(HeapWalkerNode heapWalkerNode, StringBuilder stringBuilder, int n, int n2) {
        if (n == 0) {
            stringBuilder.append(heapWalkerNode.getName());
            stringBuilder.append("     - ");
            stringBuilder.append("value: ");
            stringBuilder.append(heapWalkerNode.getType());
            stringBuilder.append(" ");
            stringBuilder.append(heapWalkerNode.getValue());
        } else {
            BrowserUtils.indent(stringBuilder, n);
            stringBuilder.append("-> ");
            stringBuilder.append(heapWalkerNode.getName());
            stringBuilder.append("     - ");
            stringBuilder.append("class: ");
            stringBuilder.append(heapWalkerNode.getParent().getType());
            stringBuilder.append(", ");
            stringBuilder.append("value: ");
            stringBuilder.append(heapWalkerNode.getType());
            stringBuilder.append(" ");
            stringBuilder.append(heapWalkerNode.getValue());
        }
    }

    private static void referenceFromRoot(HeapWalkerNode heapWalkerNode, StringBuilder stringBuilder, int n, int n2) {
        if (n == 0) {
            stringBuilder.append(heapWalkerNode.getName());
            stringBuilder.append("     - ");
            stringBuilder.append("value: ");
            stringBuilder.append(heapWalkerNode.getType());
            stringBuilder.append(" ");
            stringBuilder.append(heapWalkerNode.getValue());
        } else {
            BrowserUtils.indent(stringBuilder, n);
            stringBuilder.append("<- ");
            stringBuilder.append(heapWalkerNode.getName());
            stringBuilder.append("     - ");
            stringBuilder.append("class: ");
            stringBuilder.append(heapWalkerNode.getType());
            stringBuilder.append(", ");
            stringBuilder.append("value: ");
            stringBuilder.append(heapWalkerNode.getParent().getType());
            stringBuilder.append(" ");
            stringBuilder.append(heapWalkerNode.getParent().getValue());
        }
    }

    private static void indent(StringBuilder stringBuilder, int n) {
        while (n-- > 0) {
            stringBuilder.append(" ");
        }
    }

    public static RequestProcessor.Task performTask(Runnable runnable) {
        return REQUEST_PROCESSOR.post(runnable);
    }

    public static RequestProcessor.Task performTask(Runnable runnable, int n) {
        return REQUEST_PROCESSOR.post(runnable, n);
    }

    private static String getNodeName(HeapWalkerNode heapWalkerNode) {
        String string = heapWalkerNode.getName();
        if (string.endsWith(")")) {
            string = string.substring(0, string.indexOf(40)).trim();
        }
        return string;
    }

    public static class GroupingInfo {
        public int collapseUnitSize;
        public int containersCount;

        GroupingInfo(int n, int n2) {
            this.containersCount = n;
            this.collapseUnitSize = n2;
        }
    }
}

