/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;

public final class PoolUtils {
    private static final String MSG_MIN_IDLE = "minIdle must be non-negative.";
    public static final String MSG_NULL_KEY = "key must not be null.";
    private static final String MSG_NULL_KEYED_POOL = "keyedPool must not be null.";
    public static final String MSG_NULL_KEYS = "keys must not be null.";
    private static final String MSG_NULL_POOL = "pool must not be null.";

    public static void checkRethrow(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    public static <T> TimerTask checkMinIdle(ObjectPool<T> objectPool, int n, long l) throws IllegalArgumentException {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (n < 0) {
            throw new IllegalArgumentException(MSG_MIN_IDLE);
        }
        ObjectPoolMinIdleTimerTask<T> objectPoolMinIdleTimerTask = new ObjectPoolMinIdleTimerTask<T>(objectPool, n);
        PoolUtils.getMinIdleTimer().schedule(objectPoolMinIdleTimerTask, 0L, l);
        return objectPoolMinIdleTimerTask;
    }

    public static <K, V> TimerTask checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, K k, int n, long l) throws IllegalArgumentException {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        if (k == null) {
            throw new IllegalArgumentException(MSG_NULL_KEY);
        }
        if (n < 0) {
            throw new IllegalArgumentException(MSG_MIN_IDLE);
        }
        KeyedObjectPoolMinIdleTimerTask<K, V> keyedObjectPoolMinIdleTimerTask = new KeyedObjectPoolMinIdleTimerTask<K, V>(keyedObjectPool, k, n);
        PoolUtils.getMinIdleTimer().schedule(keyedObjectPoolMinIdleTimerTask, 0L, l);
        return keyedObjectPoolMinIdleTimerTask;
    }

    public static <K, V> Map<K, TimerTask> checkMinIdle(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n, long l) throws IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYS);
        }
        HashMap<K, TimerTask> hashMap = new HashMap<K, TimerTask>(collection.size());
        for (K k : collection) {
            TimerTask timerTask = PoolUtils.checkMinIdle(keyedObjectPool, k, n, l);
            hashMap.put(k, timerTask);
        }
        return hashMap;
    }

    @Deprecated
    public static <T> void prefill(ObjectPool<T> objectPool, int n) throws Exception, IllegalArgumentException {
        if (objectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_POOL);
        }
        objectPool.addObjects(n);
    }

    @Deprecated
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws Exception, IllegalArgumentException {
        if (keyedObjectPool == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYED_POOL);
        }
        keyedObjectPool.addObjects(k, n);
    }

    @Deprecated
    public static <K, V> void prefill(KeyedObjectPool<K, V> keyedObjectPool, Collection<K> collection, int n) throws Exception, IllegalArgumentException {
        if (collection == null) {
            throw new IllegalArgumentException(MSG_NULL_KEYS);
        }
        keyedObjectPool.addObjects(collection, n);
    }

    public static <T> PooledObjectFactory<T> synchronizedPooledFactory(PooledObjectFactory<T> pooledObjectFactory) {
        return new SynchronizedPooledObjectFactory<T>(pooledObjectFactory);
    }

    public static <K, V> KeyedPooledObjectFactory<K, V> synchronizedKeyedPooledFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) {
        return new SynchronizedKeyedPooledObjectFactory<K, V>(keyedPooledObjectFactory);
    }

    private static Timer getMinIdleTimer() {
        return TimerHolder.MIN_IDLE_TIMER;
    }

    private static final class SynchronizedKeyedPooledObjectFactory<K, V>
    implements KeyedPooledObjectFactory<K, V> {
        private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        private final KeyedPooledObjectFactory<K, V> keyedFactory;

        SynchronizedKeyedPooledObjectFactory(KeyedPooledObjectFactory<K, V> keyedPooledObjectFactory) throws IllegalArgumentException {
            if (keyedPooledObjectFactory == null) {
                throw new IllegalArgumentException("keyedFactory must not be null.");
            }
            this.keyedFactory = keyedPooledObjectFactory;
        }

        @Override
        public PooledObject<V> makeObject(K k) throws Exception {
            this.writeLock.lock();
            try {
                PooledObject<V> pooledObject = this.keyedFactory.makeObject(k);
                return pooledObject;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(K k, PooledObject<V> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.keyedFactory.destroyObject(k, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(K k, PooledObject<V> pooledObject, DestroyMode destroyMode) throws Exception {
            this.destroyObject(k, pooledObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(K k, PooledObject<V> pooledObject) {
            this.writeLock.lock();
            try {
                boolean bl = this.keyedFactory.validateObject(k, pooledObject);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void activateObject(K k, PooledObject<V> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.keyedFactory.activateObject(k, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void passivateObject(K k, PooledObject<V> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.keyedFactory.passivateObject(k, pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedKeyedPoolableObjectFactory");
            stringBuilder.append("{keyedFactory=").append(this.keyedFactory);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class SynchronizedPooledObjectFactory<T>
    implements PooledObjectFactory<T> {
        private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();
        private final PooledObjectFactory<T> factory;

        SynchronizedPooledObjectFactory(PooledObjectFactory<T> pooledObjectFactory) throws IllegalArgumentException {
            if (pooledObjectFactory == null) {
                throw new IllegalArgumentException("factory must not be null.");
            }
            this.factory = pooledObjectFactory;
        }

        @Override
        public PooledObject<T> makeObject() throws Exception {
            this.writeLock.lock();
            try {
                PooledObject<T> pooledObject = this.factory.makeObject();
                return pooledObject;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(PooledObject<T> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.factory.destroyObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void destroyObject(PooledObject<T> pooledObject, DestroyMode destroyMode) throws Exception {
            this.destroyObject(pooledObject);
        }

        @Override
        public boolean validateObject(PooledObject<T> pooledObject) {
            this.writeLock.lock();
            try {
                boolean bl = this.factory.validateObject(pooledObject);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void activateObject(PooledObject<T> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.factory.activateObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public void passivateObject(PooledObject<T> pooledObject) throws Exception {
            this.writeLock.lock();
            try {
                this.factory.passivateObject(pooledObject);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SynchronizedPoolableObjectFactory");
            stringBuilder.append("{factory=").append(this.factory);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class KeyedObjectPoolMinIdleTimerTask<K, V>
    extends TimerTask {
        private final int minIdle;
        private final K key;
        private final KeyedObjectPool<K, V> keyedPool;

        KeyedObjectPoolMinIdleTimerTask(KeyedObjectPool<K, V> keyedObjectPool, K k, int n) throws IllegalArgumentException {
            if (keyedObjectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_KEYED_POOL);
            }
            this.keyedPool = keyedObjectPool;
            this.key = k;
            this.minIdle = n;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.keyedPool.getNumIdle(this.key) < this.minIdle) {
                    this.keyedPool.addObject(this.key);
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("KeyedObjectPoolMinIdleTimerTask");
            stringBuilder.append("{minIdle=").append(this.minIdle);
            stringBuilder.append(", key=").append(this.key);
            stringBuilder.append(", keyedPool=").append(this.keyedPool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    private static final class ObjectPoolMinIdleTimerTask<T>
    extends TimerTask {
        private final int minIdle;
        private final ObjectPool<T> pool;

        ObjectPoolMinIdleTimerTask(ObjectPool<T> objectPool, int n) throws IllegalArgumentException {
            if (objectPool == null) {
                throw new IllegalArgumentException(PoolUtils.MSG_NULL_POOL);
            }
            this.pool = objectPool;
            this.minIdle = n;
        }

        @Override
        public void run() {
            boolean bl = false;
            try {
                if (this.pool.getNumIdle() < this.minIdle) {
                    this.pool.addObject();
                }
                bl = true;
            }
            catch (Exception exception) {
                this.cancel();
            }
            finally {
                if (!bl) {
                    this.cancel();
                }
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ObjectPoolMinIdleTimerTask");
            stringBuilder.append("{minIdle=").append(this.minIdle);
            stringBuilder.append(", pool=").append(this.pool);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    static class TimerHolder {
        static final Timer MIN_IDLE_TIMER = new Timer(true);

        TimerHolder() {
        }
    }
}

