/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.tomcat.util.threads.ResizableExecutor;
import org.apache.tomcat.util.threads.TaskQueue;
import org.apache.tomcat.util.threads.TaskThreadFactory;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;

public class StandardThreadExecutor
extends LifecycleMBeanBase
implements Executor,
ResizableExecutor {
    protected int threadPriority = 5;
    protected boolean daemon = true;
    protected String namePrefix = "tomcat-exec-";
    protected int maxThreads = 200;
    protected int minSpareThreads = 25;
    protected int maxIdleTime = 60000;
    protected ThreadPoolExecutor executor = null;
    protected String name;
    protected boolean prestartminSpareThreads = false;
    protected int maxQueueSize = Integer.MAX_VALUE;
    protected long threadRenewalDelay = 1000L;
    private TaskQueue taskqueue = null;

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.taskqueue = new TaskQueue(this.maxQueueSize);
        TaskThreadFactory taskThreadFactory = new TaskThreadFactory(this.namePrefix, this.daemon, this.getThreadPriority());
        this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads(), (long)this.maxIdleTime, TimeUnit.MILLISECONDS, (BlockingQueue)this.taskqueue, (ThreadFactory)taskThreadFactory);
        this.executor.setThreadRenewalDelay(this.threadRenewalDelay);
        if (this.prestartminSpareThreads) {
            this.executor.prestartAllCoreThreads();
        }
        this.taskqueue.setParent(this.executor);
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
        this.taskqueue = null;
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        super.destroyInternal();
    }

    @Override
    public void execute(Runnable runnable, long l, TimeUnit timeUnit) {
        if (this.executor == null) {
            throw new IllegalStateException("StandardThreadExecutor not started.");
        }
        this.executor.execute(runnable, l, timeUnit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable runnable) {
        if (this.executor == null) throw new IllegalStateException("StandardThreadPool not started.");
        try {
            this.executor.execute(runnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (((TaskQueue)this.executor.getQueue()).force(runnable)) return;
            throw new RejectedExecutionException("Work queue full.");
        }
    }

    public void contextStopping() {
        if (this.executor != null) {
            this.executor.contextStopping();
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isPrestartminSpareThreads() {
        return this.prestartminSpareThreads;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public void setNamePrefix(String string) {
        this.namePrefix = string;
    }

    public void setMaxIdleTime(int n) {
        this.maxIdleTime = n;
        if (this.executor != null) {
            this.executor.setKeepAliveTime((long)n, TimeUnit.MILLISECONDS);
        }
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
        if (this.executor != null) {
            this.executor.setMaximumPoolSize(n);
        }
    }

    public void setMinSpareThreads(int n) {
        this.minSpareThreads = n;
        if (this.executor != null) {
            this.executor.setCorePoolSize(n);
        }
    }

    public void setPrestartminSpareThreads(boolean bl) {
        this.prestartminSpareThreads = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setMaxQueueSize(int n) {
        this.maxQueueSize = n;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long l) {
        this.threadRenewalDelay = l;
        if (this.executor != null) {
            this.executor.setThreadRenewalDelay(l);
        }
    }

    public int getActiveCount() {
        return this.executor != null ? this.executor.getActiveCount() : 0;
    }

    public long getCompletedTaskCount() {
        return this.executor != null ? this.executor.getCompletedTaskCount() : 0L;
    }

    public int getCorePoolSize() {
        return this.executor != null ? this.executor.getCorePoolSize() : 0;
    }

    public int getLargestPoolSize() {
        return this.executor != null ? this.executor.getLargestPoolSize() : 0;
    }

    public int getPoolSize() {
        return this.executor != null ? this.executor.getPoolSize() : 0;
    }

    public int getQueueSize() {
        return this.executor != null ? this.executor.getQueue().size() : -1;
    }

    public boolean resizePool(int n, int n2) {
        if (this.executor == null) {
            return false;
        }
        this.executor.setCorePoolSize(n);
        this.executor.setMaximumPoolSize(n2);
        return true;
    }

    public boolean resizeQueue(int n) {
        return false;
    }

    @Override
    protected String getDomainInternal() {
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Executor,name=" + this.getName();
    }
}

