/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.options.keymap.Popupable;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.netbeans.modules.options.keymap.SpecialkeyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutCellPanel
extends JPanel
implements Comparable,
Popupable {
    private Popup popup;
    private final SpecialkeyPanel specialkeyList;
    PopupFactory factory = PopupFactory.getSharedInstance();
    private JButton changeButton;
    private JTextField scField;

    public ShortcutCellPanel() {
        this.initComponents();
        this.specialkeyList = new SpecialkeyPanel(this, this.scField);
        this.changeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ShortcutCellPanel.this.hidePopup();
            }
        });
        this.changeButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    JTable jTable = (JTable)ShortcutCellPanel.this.scField.getParent().getParent();
                    int n = jTable.getEditingRow();
                    jTable.editCellAt(n, 1);
                    jTable.setRowSelectionInterval(n, n);
                    ShortcutCellPanel.this.scField.requestFocus();
                    return;
                }
            }
        });
        this.scField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ShortcutCellPanel.this.changeButton.setText("");
                ShortcutCellPanel.this.changeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/options/keymap/more_opened.png")));
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ShortcutCellPanel.this.changeButton.setIcon(null);
                ShortcutCellPanel.this.changeButton.setText("...");
            }
        });
        this.setFocusable(true);
    }

    ShortcutCellPanel(String string) {
        this();
        this.setText(string);
    }

    public void setText(String string) {
        this.scField.setText(string);
    }

    @Override
    public void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public String toString() {
        return this.scField.getText();
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        int n = this.changeButton.getPreferredSize().width;
        this.scField.setPreferredSize(new Dimension(dimension.width - n, dimension.height));
        this.changeButton.setPreferredSize(new Dimension(n, dimension.height));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        if (color instanceof UIResource) {
            super.setBackground(new Color(color.getRGB()));
        }
        super.paintComponent(graphics);
        super.setBackground(color);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.scField != null) {
            this.scField.setBackground(color);
        }
    }

    void setBgColor(Color color) {
        this.setBackground(color);
        Color color2 = UIManager.getDefaults().getColor("control");
        if (color2 == null) {
            color2 = new Color(204, 204, 204);
        }
        this.changeButton.setBackground(color2);
    }

    void setFgCOlor(Color color, boolean bl) {
        Color color2 = bl ? UIManager.getDefaults().getColor("List[Selected].textForeground") : UIManager.getDefaults().getColor("Label.foreground");
        if (color2 != null) {
            color = !(color2 instanceof UIResource) ? new ColorUIResource(color2) : color2;
        }
        this.scField.setForeground(color);
    }

    public JButton getButton() {
        return this.changeButton;
    }

    public JTextField getTextField() {
        return this.scField;
    }

    private void initComponents() {
        this.scField = new ShortcutTextField();
        this.changeButton = new JButton();
        this.setBackground(new Color(204, 204, 204));
        this.setPreferredSize(new Dimension(134, 15));
        this.scField.setText(NbBundle.getMessage(ShortcutCellPanel.class, (String)"ShortcutCellPanel.scField.text"));
        this.scField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.changeButton.setBackground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage(ShortcutCellPanel.class, (String)"ShortcutCellPanel.changeButton.text"));
        this.changeButton.setHorizontalTextPosition(0);
        this.changeButton.setMaximumSize(new Dimension(25, 15));
        this.changeButton.setMinimumSize(new Dimension(25, 15));
        this.changeButton.setPreferredSize(new Dimension(25, 15));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutCellPanel.this.changeButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scField, -1, 109, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.changeButton, -2, 25, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scField, -2, 15, -2).addComponent(this.changeButton, -2, 15, -2));
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        JButton jButton = this.changeButton;
        Point point = new Point(jButton.getX(), jButton.getY());
        SwingUtilities.convertPointToScreen(point, this);
        if (this.popup == null) {
            this.changeButton.setText("");
            this.changeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/options/keymap/more_closed.png")));
            this.popup = Utilities.isUnix() ? PopupFactory.getSharedInstance().getPopup(null, this.specialkeyList, point.x, point.y + jButton.getHeight()) : this.factory.getPopup(this, this.specialkeyList, point.x, point.y + jButton.getHeight());
            this.popup.show();
        } else {
            this.changeButton.setText("");
            this.changeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/options/keymap/more_opened.png")));
            this.hidePopup();
        }
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    @Override
    public Popup getPopup() {
        return this.popup;
    }

    void setButtontext(String string) {
        this.changeButton.setText(string);
    }
}

