/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.provider.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.AbstractCompoundIterator;
import org.openide.filesystems.FileObject;

public class CompoundSearchInfo
extends SearchInfo {
    private final SearchInfo[] elements;

    public CompoundSearchInfo(SearchInfo ... searchInfoArray) {
        if (searchInfoArray == null) {
            throw new IllegalArgumentException();
        }
        this.elements = searchInfoArray.length != 0 ? searchInfoArray : null;
    }

    @Override
    public boolean canSearch() {
        if (this.elements != null) {
            for (SearchInfo searchInfo : this.elements) {
                if (!searchInfo.canSearch()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FileObject> createFilesToSearchIterator(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        if (this.elements == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(this.elements.length);
        for (SearchInfo searchInfo : this.elements) {
            if (!searchInfo.canSearch()) continue;
            arrayList.add(searchInfo);
        }
        return new AbstractCompoundIterator<SearchInfo, FileObject>(arrayList.toArray(new SearchInfo[arrayList.size()]), searchScopeOptions, searchListener, atomicBoolean){

            @Override
            protected Iterator<FileObject> getIteratorFor(SearchInfo searchInfo, SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
                return searchInfo.getFilesToSearch(searchScopeOptions, searchListener, atomicBoolean).iterator();
            }
        };
    }

    @Override
    protected Iterator<URI> createUrisToSearchIterator(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        if (this.elements == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(this.elements.length);
        for (SearchInfo searchInfo : this.elements) {
            if (!searchInfo.canSearch()) continue;
            arrayList.add(searchInfo);
        }
        return new AbstractCompoundIterator<SearchInfo, URI>(arrayList.toArray(new SearchInfo[arrayList.size()]), searchScopeOptions, searchListener, atomicBoolean){

            @Override
            protected Iterator<URI> getIteratorFor(SearchInfo searchInfo, SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
                return searchInfo.getUrisToSearch(searchScopeOptions, searchListener, atomicBoolean).iterator();
            }
        };
    }

    @Override
    public List<SearchRoot> getSearchRoots() {
        LinkedList<SearchRoot> linkedList = new LinkedList<SearchRoot>();
        for (SearchInfo searchInfo : this.elements) {
            linkedList.addAll(searchInfo.getSearchRoots());
        }
        return linkedList;
    }
}

