/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.ProblemPanel;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.actions.ShowNotifications;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());
    private static Boolean isModulesOnly;
    private static String PLUGIN_MANAGER_MODULES_ONLY;
    private static String PLUGIN_MANAGER_SHARED_INSTALLATION;
    public static String PLUGIN_MANAGER_CHECK_INTERVAL;
    public static String PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION;
    public static final SimpleDateFormat DATE_FORMAT;
    public static final String TIME_OF_MODEL_INITIALIZATION = "time_of_model_initialization";
    public static final String TIME_OF_REFRESH_UPDATE_CENTERS = "time_of_refresh_update_centers";
    static final String UNSORTED_CATEGORY;
    static final String LIBRARIES_CATEGORY;
    static final String BRIDGES_CATEGORY;
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";
    private static final String ALLOW_SHOWING_BALLOON = "plugin.manager.allow.showing.balloon";
    private static final String SHOWING_BALLOON_TIMEOUT = "plugin.manager.showing.balloon.timeout";
    private static final RequestProcessor WORKER_THREADS_PROCESSOR;
    private static Collection<String> first_class_modules;
    private static Set<String> acceptedLicenseIDs;
    public static final String PLUGIN_MANAGER_ACCEPTED_LICENSE_IDS = "plugin_manager_accepted_license_ids";

    public static List<UnitCategory> makeInstalledCategories(List<UpdateUnit> list) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateElement == null && !updateUnit.isPending()) continue;
            String string = updateElement == null && updateUnit.isPending() ? ((UpdateElement)updateUnit.getAvailableUpdates().get(0)).getCategory() : updateElement.getCategory();
            Unit.Installed installed = new Unit.Installed(updateUnit, string);
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(installed);
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(installed);
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeInstalledCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    private static Set<String> getAcceptedLicenseIds() {
        if (acceptedLicenseIDs == null) {
            Utilities.initAcceptedLicenseIDs();
        }
        return acceptedLicenseIDs;
    }

    public static boolean isLicenseIdApproved(String string) {
        if (string == null) {
            return false;
        }
        logger.finest("License ID - Was " + string + " accepted? " + Utilities.getAcceptedLicenseIds().contains(string));
        return Utilities.getAcceptedLicenseIds().contains(string);
    }

    public static void addAcceptedLicenseIDs(Collection<String> collection) {
        logger.fine("License ID - License ID " + collection + " was accepted.");
        if (collection != null) {
            Utilities.getAcceptedLicenseIds().addAll(collection);
        }
    }

    public static void storeAcceptedLicenseIDs() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't call in AWT queue";
        if (acceptedLicenseIDs == null) {
            Utilities.initAcceptedLicenseIDs();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : acceptedLicenseIDs) {
            stringBuilder.append(string).append(",");
        }
        Utilities.getPreferences().put(PLUGIN_MANAGER_ACCEPTED_LICENSE_IDS, stringBuilder.length() == 0 ? "" : stringBuilder.substring(0, stringBuilder.length() - 1));
        logger.fine("License IDs - Stored: " + (stringBuilder.length() == 0 ? "" : stringBuilder.substring(0, stringBuilder.length() - 1)));
    }

    public static synchronized void initAcceptedLicenseIDs() {
        Object object;
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't call in AWT queue";
        if (acceptedLicenseIDs == null) {
            acceptedLicenseIDs = Collections.newSetFromMap(new ConcurrentHashMap());
            object = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE}).iterator();
            while (object.hasNext()) {
                String string;
                UpdateUnit updateUnit = (UpdateUnit)object.next();
                UpdateElement updateElement = updateUnit.getInstalled();
                if (updateElement == null || (string = updateElement.getLicenseId()) == null) continue;
                acceptedLicenseIDs.add(string);
            }
        }
        if ((object = Utilities.getPreferences().get(PLUGIN_MANAGER_ACCEPTED_LICENSE_IDS, null)) != null) {
            acceptedLicenseIDs.addAll(Arrays.asList(((String)object).split(",")));
        }
        logger.fine("License IDs - Loaded: " + acceptedLicenseIDs);
    }

    public static List<UnitCategory> makeUpdateCategories(List<UpdateUnit> list, boolean bl) {
        Unit.CompoundUpdate compoundUpdate;
        UnitCategory unitCategory;
        String string;
        List list2;
        UpdateElement updateElement;
        List<UnitCategory> list3;
        long l = System.currentTimeMillis();
        Utilities.clearFirstClassModules();
        if (!bl && !list.isEmpty()) {
            list3 = Utilities.makeFirstClassUpdateCategories();
            if (!list3.isEmpty()) {
                return list3;
            }
            if (Utilities.hasPendingFirstClassModules()) {
                return new ArrayList<UnitCategory>();
            }
        }
        list3 = new HashMap();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<UpdateUnit> hashSet = new HashSet<UpdateUnit>();
        HashMap<Object, Unit.CompoundUpdate> hashMap = new HashMap<Object, Unit.CompoundUpdate>();
        for (UpdateUnit object : list) {
            updateElement = object.getInstalled();
            if (object.isPending() || updateElement == null || !updateElement.isEnabled() && !bl || (list2 = object.getAvailableUpdates()).isEmpty()) continue;
            if (UpdateManager.TYPE.KIT_MODULE.equals((Object)object.getType()) || bl) {
                string = updateElement.getCategory();
                if (!list3.containsKey(string)) {
                    list3.put(string, new UnitCategory(string));
                }
                unitCategory = (UnitCategory)list3.get(string);
                if (bl) {
                    unitCategory.addUnit(new Unit.Update(object, bl, string));
                    continue;
                }
                compoundUpdate = new Unit.CompoundUpdate(object, string);
                unitCategory.addUnit(compoundUpdate);
                logger.finest("Kit " + object + " makes compound unit " + compoundUpdate);
                hashMap.put(object, compoundUpdate);
                continue;
            }
            hashSet.add(object);
        }
        if (hashSet.size() > 0 && !bl) {
            for (UpdateUnit updateUnit : hashSet) {
                updateElement = updateUnit.getVisibleAncestor();
                if (updateElement == null || updateElement.getInstalled() == null) {
                    updateElement = updateUnit;
                }
                list2 = updateElement.getInstalled();
                logger.finer(updateUnit + " -> " + updateElement);
                if (hashMap.containsKey(updateElement)) {
                    logger.finest(updateUnit + " belongs to " + updateElement);
                } else {
                    string = list2.getCategory();
                    if (!list3.containsKey(string)) {
                        list3.put(string, new UnitCategory(string));
                    }
                    unitCategory = (UnitCategory)list3.get(string);
                    compoundUpdate = new Unit.CompoundUpdate((UpdateUnit)updateElement, string);
                    unitCategory.addUnit(compoundUpdate);
                    logger.finest(updateElement + " makes new compound unit " + compoundUpdate);
                    hashMap.put(updateElement, compoundUpdate);
                }
                ((Unit.CompoundUpdate)hashMap.get(updateElement)).getUpdateUnits().add(updateUnit);
            }
            for (Unit.CompoundUpdate compoundUpdate2 : new HashSet(hashMap.values())) {
                compoundUpdate2.initState();
            }
        }
        logger.log(Level.FINE, "makeUpdateCategories (" + list.size() + ") returns " + list3.size() + ", took " + (System.currentTimeMillis() - l) + " ms");
        return new ArrayList<UnitCategory>(list3.values());
    }

    public static long getTimeOfInitialization() {
        return Utilities.getPreferences().getLong(TIME_OF_MODEL_INITIALIZATION, 0L);
    }

    public static void putTimeOfInitialization(long l) {
        Utilities.getPreferences().putLong(TIME_OF_MODEL_INITIALIZATION, l);
    }

    public static long getTimeOfRefreshUpdateCenters() {
        return Utilities.getPreferences().getLong(TIME_OF_REFRESH_UPDATE_CENTERS, 0L);
    }

    public static void putTimeOfRefreshUpdateCenters(long l) {
        Utilities.getPreferences().putLong(TIME_OF_REFRESH_UPDATE_CENTERS, l);
    }

    private static List<UnitCategory> makeFirstClassUpdateCategories() {
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Collection<String> collection = Utilities.getFirstClassModules();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateUnit.isPending() || updateElement == null || (list2 = updateUnit.getAvailableUpdates()).isEmpty() || !collection.contains(updateElement.getCodeName())) continue;
            String string = updateElement.getCategory();
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(new Unit.Update(updateUnit, false, string));
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(new Unit.Update(updateUnit, false, string));
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeFirstClassUpdateCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    private static boolean hasPendingFirstClassModules() {
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<String> collection = Utilities.getFirstClassModules();
        for (UpdateUnit updateUnit : list) {
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (!updateUnit.isPending() || updateElement == null || (list2 = updateUnit.getAvailableUpdates()).isEmpty() || !collection.contains(updateElement.getCodeName())) continue;
            return true;
        }
        return false;
    }

    public static List<UnitCategory> makeAvailableCategories(List<UpdateUnit> list, boolean bl) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateUnit.isPending() || updateElement != null || (list2 = updateUnit.getAvailableUpdates()) == null || list2.isEmpty()) continue;
            UpdateElement updateElement2 = (UpdateElement)list2.get(0);
            String string = updateElement2.getCategory();
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(new Unit.Available(updateUnit, bl, string));
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(new Unit.Available(updateUnit, bl, string));
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeAvailableCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    public static void showURL(URL uRL) {
        HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (uRLDisplayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (uRLDisplayer != null) {
            uRLDisplayer.showURL(uRL);
        } else {
            logger.log(Level.INFO, "No URLDisplayer found.");
        }
    }

    public static String getDownloadSizeAsString(int n) {
        int n2 = n / 0x40000000;
        if (n2 > 0) {
            return n2 + Utilities.getBundle("Utilities_DownloadSize_GB", new Object[0]);
        }
        int n3 = n / 0x100000;
        if (n3 > 0) {
            return n3 + Utilities.getBundle("Utilities_DownloadSize_MB", new Object[0]);
        }
        int n4 = n / 1024;
        if (n4 > 0) {
            return n4 + Utilities.getBundle("Utilities_DownloadSize_kB", new Object[0]);
        }
        return n + Utilities.getBundle("Utilities_DownloadSize_B", new Object[0]);
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(Utilities.class, (String)string, (Object[])objectArray);
    }

    public static void presentRefreshProvider(UpdateUnitProvider updateUnitProvider, PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(Collections.singleton(updateUnitProvider), pluginManagerUI, bl);
    }

    public static void presentRefreshProviders(Collection<UpdateUnitProvider> collection, PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(collection, pluginManagerUI, bl);
    }

    public static void presentRefreshProviders(PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProviders() call in EQ!";
        Utilities.doRefreshProviders(null, pluginManagerUI, bl);
    }

    private static void doRefreshProviders(Collection<UpdateUnitProvider> collection, PluginManagerUI pluginManagerUI, boolean bl) {
        boolean bl2 = false;
        while (!bl2) {
            bl2 = Utilities.tryRefreshProviders(collection, pluginManagerUI, bl);
        }
    }

    public static void showProviderNotification(UpdateUnitProvider updateUnitProvider) {
        ShowNotifications.checkNotification(updateUnitProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryRefreshProviders(Collection<UpdateUnitProvider> list, PluginManagerUI pluginManagerUI, boolean bl) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SettingsTableModel.class, (String)"Utilities_CheckingForUpdates"));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        jLabel.setHorizontalAlignment(2);
        try {
            pluginManagerUI.setProgressComponent(jLabel, jComponent);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            if (list == null) {
                list = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
            }
            for (UpdateUnitProvider updateUnitProvider : list) {
                try {
                    updateUnitProvider.refresh(progressHandle, bl);
                    Utilities.showProviderNotification(updateUnitProvider);
                }
                catch (IOException iOException) {
                    boolean bl2;
                    block12: {
                        logger.log(Level.INFO, iOException.getMessage(), iOException);
                        JButton jButton = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Utilities.getBundle("Utilities_NetworkProblem_Cancel", new Object[0]));
                        JButton jButton2 = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)Utilities.getBundle("Utilities_NetworkProblem_Skip", new Object[0]));
                        jButton2.setEnabled(list.size() > 1);
                        JButton jButton3 = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)Utilities.getBundle("Utilities_NetworkProblem_Continue", new Object[0]));
                        ProblemPanel problemPanel = new ProblemPanel(Utilities.getBundle("Utilities_NetworkProblem_Text", updateUnitProvider.getDisplayName(), iOException.getLocalizedMessage()), jButton3, jButton2, jButton);
                        Object object = problemPanel.showNetworkProblemDialog();
                        if (jButton2.equals(object)) continue;
                        if (jButton3.equals(object)) {
                            boolean bl3 = false;
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            Containers.initNotify();
                            pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                            return bl3;
                        }
                        try {
                            bl2 = true;
                            if (progressHandle == null) break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return true;
                        }
                        progressHandle.finish();
                    }
                    Containers.initNotify();
                    pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                    return bl2;
                }
            }
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
            Containers.initNotify();
            pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
        }
    }

    public static void startAsWorkerThread(PluginManagerUI pluginManagerUI, Runnable runnable, String string) {
        Utilities.startAsWorkerThread(pluginManagerUI, runnable, string, 0L);
    }

    public static void startAsWorkerThread(final PluginManagerUI pluginManagerUI, final Runnable runnable, final String string, final long l) {
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
                try {
                    jLabel.setHorizontalAlignment(2);
                    pluginManagerUI.setProgressComponent(jLabel, jComponent);
                    progressHandle.setInitialDelay(0);
                    if (l == 0L) {
                        progressHandle.start();
                        progressHandle.progress(string);
                        runnable.run();
                    } else {
                        assert (l > 0L) : "Estimated time " + l;
                        final long l2 = l + 2L;
                        progressHandle.start((int)l2 * 10, l2);
                        progressHandle.progress(string, 0);
                        final RequestProcessor.Task task = Installer.RP.post(runnable);
                        RequestProcessor.Task task2 = Installer.RP.post(new Runnable(){

                            @Override
                            public void run() {
                                int n = 0;
                                while (!task.isFinished()) {
                                    try {
                                        if (l2 * 10L <= (long)n++) {
                                            progressHandle.switchToIndeterminate();
                                            progressHandle.progress(string);
                                            return;
                                        }
                                        progressHandle.progress(string, n);
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                        });
                        task.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                task.removeTaskListener((TaskListener)this);
                                progressHandle.finish();
                            }
                        });
                        task.waitFinished();
                    }
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                    pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                }
            }
        });
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnable) {
        return Utilities.startAsWorkerThread(runnable, 0);
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnable, int n) {
        RequestProcessor.Task task = WORKER_THREADS_PROCESSOR.create(runnable);
        if (SwingUtilities.isEventDispatchThread()) {
            task.schedule(n);
        } else {
            if (n > 0) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            task.run();
        }
        return task;
    }

    public static UpdateManager.TYPE[] getUnitTypes() {
        if (Utilities.modulesOnly()) {
            return new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE};
        }
        return new UpdateManager.TYPE[]{UpdateManager.TYPE.KIT_MODULE, UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT};
    }

    public static Boolean isGlobalInstallation() {
        String string = Utilities.getPreferences().get(PLUGIN_MANAGER_SHARED_INSTALLATION, System.getProperty("plugin.manager.install.global"));
        if (Boolean.parseBoolean(string)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static void setGlobalInstallation(Boolean bl) {
        Utilities.getPreferences().put(PLUGIN_MANAGER_SHARED_INSTALLATION, bl == null ? "null" : bl.toString());
    }

    public static boolean modulesOnly() {
        return isModulesOnly == null ? Utilities.modulesOnlyDefault() : isModulesOnly;
    }

    public static boolean showExtendedDescription() {
        return Boolean.valueOf(System.getProperty("plugin.manager.extended.description"));
    }

    public static String getCustomCheckIntervalInMinutes() {
        return System.getProperty(PLUGIN_MANAGER_CHECK_INTERVAL);
    }

    private static String getCustomFirstClassModules() {
        return System.getProperty(PLUGIN_MANAGER_FIRST_CLASS_MODULES);
    }

    private static String getFirstClassModuleNames() {
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        return preferences.get(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
    }

    public static void clearFirstClassModules() {
        first_class_modules = null;
    }

    public static Collection<String> getFirstClassModules() {
        if (first_class_modules != null) {
            return first_class_modules;
        }
        String string = Utilities.getCustomFirstClassModules();
        if (string == null || string.length() == 0) {
            string = Utilities.getFirstClassModuleNames();
        }
        first_class_modules = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            first_class_modules.add(stringTokenizer.nextToken().trim());
        }
        return first_class_modules;
    }

    public static Boolean allowShowingBalloon() {
        String string = System.getProperty(ALLOW_SHOWING_BALLOON);
        return string == null ? null : Boolean.valueOf(string);
    }

    public static int getShowingBalloonTimeout() {
        String string = System.getProperty(SHOWING_BALLOON_TIMEOUT);
        int n = 30000;
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.INFO, numberFormatException + " while parsing " + string + " for " + SHOWING_BALLOON_TIMEOUT);
        }
        return n;
    }

    public static boolean shouldCheckAvailableNewPlugins() {
        String string = System.getProperty("plugin.manager.check.new.plugins");
        return string == null ? false : Boolean.valueOf(string);
    }

    public static boolean shouldCheckAvailableUpdates() {
        String string = System.getProperty("plugin.manager.check.updates");
        return string == null ? true : Boolean.valueOf(string);
    }

    public static void setModulesOnly(boolean bl) {
        isModulesOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        Utilities.getPreferences().putBoolean(PLUGIN_MANAGER_MODULES_ONLY, isModulesOnly);
    }

    private static boolean modulesOnlyDefault() {
        return Utilities.getPreferences().getBoolean(PLUGIN_MANAGER_MODULES_ONLY, Boolean.valueOf(System.getProperty("plugin.manager.modules.only")));
    }

    public static Comparator<String> getCategoryComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return Collator.getInstance().compare(string, string2);
            }
        };
    }

    public static List<File> sharedDirs() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (object.hasMoreElements()) {
                File file = new File((String)object.nextElement());
                arrayList.add(file);
            }
        }
        if ((object = Utilities.getPlatformDir()) != null) {
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteInCluster(File file) {
        File file2;
        assert (file != null) : "dir cannot be null";
        assert (file.exists()) : file + " must exists";
        assert (file.isDirectory()) : file + " is directory";
        if (file == null || !file.exists() || !file.isDirectory()) {
            logger.log(Level.INFO, "Invalid cluster " + file);
            return false;
        }
        if (file.canWrite() && file.canRead() && org.openide.util.Utilities.isWindows() && (file2 = new File(file, "update_tracking")).exists() && file2.isDirectory()) {
            for (File file3 : file2.listFiles()) {
                if (!file3.exists() || !file3.isFile()) continue;
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(file3, true);
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, file3 + " has no write permission", iOException);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
                logger.log(Level.FINE, file3 + " has write permission");
                return true;
            }
        }
        logger.log(Level.FINE, "Can write into " + file + "? " + file.canWrite());
        return file.canWrite();
    }

    private static File getPlatformDir() {
        String string = System.getProperty("netbeans.home");
        return string == null ? null : new File(string);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }

    static {
        PLUGIN_MANAGER_MODULES_ONLY = "plugin_manager_modules_only";
        PLUGIN_MANAGER_SHARED_INSTALLATION = "plugin_manager_shared_installation";
        PLUGIN_MANAGER_CHECK_INTERVAL = "plugin.manager.check.interval";
        PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION = "plugin_manager_dont_care_write_permission";
        DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
        UNSORTED_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Unsorted_Category");
        LIBRARIES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Libraries_Category");
        BRIDGES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Bridges_Category");
        WORKER_THREADS_PROCESSOR = new RequestProcessor("autoupdate-ui-worker", 10, false);
        first_class_modules = null;
    }
}

