/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaThreadsHTML;
import com.sun.tools.visualvm.heapviewer.java.impl.JavaThreadsObjects;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import com.sun.tools.visualvm.heapviewer.model.RootNode;
import com.sun.tools.visualvm.heapviewer.ui.HTMLView;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerFeature;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerNodeAction;
import com.sun.tools.visualvm.heapviewer.ui.PluggableTreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.api.icons.Icons;

public class JavaThreadsView
extends HeapViewerFeature {
    private static final String FEATURE_ID = "java_threads";
    private static final String VIEW_OBJECTS_ID = "java_threads_objects";
    private static final String VIEW_HTML_ID = "java_threads_html";
    private JComponent component;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar pluginsToolbar;
    private final HTMLView htmlView;
    private final PluggableTreeTableView objectsView;
    private JToggleButton rObjects;
    private JToggleButton rHTML;

    public JavaThreadsView(HeapContext context, HeapViewerActions actions) {
        super(FEATURE_ID, Bundle.JavaThreadsView_Name(), Bundle.JavaThreadsView_Description(), Icons.getIcon((String)"ProfilerIcons.WindowThreads"), 300);
        Heap heap = context.getFragment().getHeap();
        this.objectsView = new PluggableTreeTableView(VIEW_OBJECTS_ID, context, actions, TreeTableViewColumn.instances(heap, false)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) {
                return JavaThreadsObjects.getThreads(root, heap);
            }

            @Override
            protected void childrenChanged() {
                HeapViewerNode[] children;
                for (HeapViewerNode child : children = this.getRoot().getChildren()) {
                    this.expandNode(child);
                }
            }

            @Override
            protected void populatePopup(HeapViewerNode node, JPopupMenu popup) {
                if (popup.getComponentCount() > 0) {
                    popup.addSeparator();
                }
                popup.add(new AbstractAction(Bundle.JavaThreadsView_ExpandAction()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HeapViewerNode[] children;
                                for (HeapViewerNode child : children = this.getRoot().getChildren()) {
                                    this.expandNode(child);
                                }
                            }
                        });
                    }
                });
                popup.add(new AbstractAction(Bundle.JavaThreadsView_CollapseAction()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.collapseChildren(this.getRoot());
                            }
                        });
                    }
                });
            }
        };
        this.objectsView.setViewName(Bundle.JavaThreadsView_Name());
        this.htmlView = new HTMLView(VIEW_HTML_ID, context, actions, Bundle.JavaThreadsView_ComputingThreads()){

            @Override
            protected String computeData(HeapContext context, String viewID) {
                return JavaThreadsHTML.getThreads(context);
            }

            @Override
            protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
                return JavaThreadsHTML.getNode(url, context);
            }
        };
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    void selectInstance(long instanceID, String viewID) {
        if (this.rHTML == null) {
            this.init();
        }
        this.rHTML.setSelected(true);
        this.htmlView.selectReference(Long.toString(instanceID));
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaThreadsView_Results()));
        this.toolbar.addSpace(3);
        ButtonGroup resultsBG = new ButtonGroup();
        this.rObjects = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots"), true){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (JavaThreadsView.this.component != null) {
                        ((CardLayout)JavaThreadsView.this.component.getLayout()).first(JavaThreadsView.this.component);
                    }
                    if (JavaThreadsView.this.pluginsToolbar != null) {
                        JavaThreadsView.this.pluginsToolbar.getComponent().setVisible(true);
                    }
                }
            }
        };
        this.rObjects.putClientProperty("JButton.buttonType", "segmented");
        this.rObjects.putClientProperty("JButton.segmentPosition", "first");
        this.rObjects.setToolTipText(Bundle.JavaThreadsView_TooltipObjects());
        resultsBG.add(this.rObjects);
        this.toolbar.add((Component)this.rObjects);
        this.rHTML = new JToggleButton(Icons.getIcon((String)"HeapWalkerIcons.Properties")){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (JavaThreadsView.this.component != null) {
                        ((CardLayout)JavaThreadsView.this.component.getLayout()).last(JavaThreadsView.this.component);
                    }
                    if (JavaThreadsView.this.pluginsToolbar != null) {
                        JavaThreadsView.this.pluginsToolbar.getComponent().setVisible(false);
                    }
                }
            }
        };
        this.rHTML.putClientProperty("JButton.buttonType", "segmented");
        this.rHTML.putClientProperty("JButton.segmentPosition", "last");
        this.rHTML.setToolTipText(Bundle.JavaThreadsView_TooltipHTML());
        resultsBG.add(this.rHTML);
        this.toolbar.add((Component)this.rHTML);
        if (this.objectsView.hasPlugins()) {
            this.pluginsToolbar = ProfilerToolbar.create((boolean)false);
            this.pluginsToolbar.addSpace(8);
            this.pluginsToolbar.add((Component)new GrayLabel(Bundle.JavaThreadsView_Details()));
            this.pluginsToolbar.addSpace(2);
            this.pluginsToolbar.add(this.objectsView.getToolbar());
            this.toolbar.add(this.pluginsToolbar);
        }
        this.component = new JPanel(new CardLayout());
        this.component.add(this.objectsView.getComponent());
        this.component.add((Component)new ScrollableContainer(this.htmlView.getComponent()));
    }

    public static class SelectInstanceActionProvider
    extends HeapViewerNodeAction.Provider {
        @Override
        public boolean supportsView(HeapContext context, String viewID) {
            return !JavaThreadsView.VIEW_HTML_ID.equals(viewID) && JavaHeapFragment.isJavaHeap(context);
        }

        @Override
        public HeapViewerNodeAction[] getActions(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            Heap heap = context.getFragment().getHeap();
            Instance instance = HeapViewerNode.getValue(node, DataType.INSTANCE, heap);
            if (instance == null) {
                return null;
            }
            GCRoot gcRoot = heap.getGCRoot(instance);
            if (gcRoot == null || !"Java frame".equals(gcRoot.getKind())) {
                return null;
            }
            JavaFrameGCRoot frameVar = (JavaFrameGCRoot)gcRoot;
            if (frameVar.getFrameNumber() == -1) {
                return null;
            }
            return new HeapViewerNodeAction[]{new SelectInstanceAction(instance.getInstanceId(), actions)};
        }
    }

    private static class SelectInstanceAction
    extends HeapViewerNodeAction {
        private final long id;
        private final HeapViewerActions actions;

        SelectInstanceAction(long id, HeapViewerActions actions) {
            super(Bundle.JavaThreadsView_SelectAction(), 205);
            this.id = id;
            this.actions = actions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeapViewerFeature feature = this.actions.findFeature(JavaThreadsView.FEATURE_ID);
            if (feature instanceof JavaThreadsView) {
                this.actions.selectFeature(feature);
                ((JavaThreadsView)feature).selectInstance(this.id, JavaThreadsView.VIEW_HTML_ID);
            }
        }
    }

    public static class Provider
    extends HeapViewerFeature.Provider {
        @Override
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new JavaThreadsView(context, actions);
            }
            return null;
        }
    }
}

