/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.model;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNodeFilter;
import com.sun.tools.visualvm.heapviewer.model.Progress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.netbeans.lib.profiler.heap.Heap;
import org.openide.util.Lookup;

public abstract class RootNode
extends HeapViewerNode {
    private Collection<? extends HeapViewerNode.Provider> nodeProviders;
    private Collection<? extends DataType.ValueProvider> valueProviders;

    public abstract HeapContext getContext();

    public abstract String getViewID();

    public abstract HeapViewerNodeFilter getViewFilter();

    public abstract List<DataType> getDataTypes();

    public abstract List<SortOrder> getSortOrders();

    public abstract void refreshNode(HeapViewerNode var1);

    protected abstract void updateChildren(HeapViewerNode var1);

    protected abstract HeapViewerNode[] retrieveChildren(HeapViewerNode var1);

    @Override
    public void resetChildren() {
        super.resetChildren();
    }

    public boolean equals(Object o) {
        return o instanceof RootNode && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "root of " + this.getViewID();
    }

    @Override
    protected abstract HeapViewerNode[] lazilyComputeChildren(Heap var1, String var2, HeapViewerNodeFilter var3, List<DataType> var4, List<SortOrder> var5, Progress var6);

    synchronized Collection<? extends HeapViewerNode.Provider> getNodeProviders() {
        if (this.nodeProviders == null) {
            this.nodeProviders = Lookup.getDefault().lookupAll(HeapViewerNode.Provider.class);
            if (!this.nodeProviders.isEmpty()) {
                this.nodeProviders = new ArrayList<HeapViewerNode.Provider>(this.nodeProviders);
                Iterator<? extends HeapViewerNode.Provider> providers = this.nodeProviders.iterator();
                Heap heap = this.getContext().getFragment().getHeap();
                String viewID = this.getViewID();
                while (providers.hasNext()) {
                    if (providers.next().supportsView(heap, viewID)) continue;
                    providers.remove();
                }
            }
        }
        return this.nodeProviders;
    }

    synchronized Collection<? extends DataType.ValueProvider> getValueProviders() {
        if (this.valueProviders == null) {
            this.valueProviders = Lookup.getDefault().lookupAll(DataType.ValueProvider.class);
            if (!this.valueProviders.isEmpty()) {
                this.valueProviders = new ArrayList<DataType.ValueProvider>(this.valueProviders);
                Iterator<? extends DataType.ValueProvider> providers = this.valueProviders.iterator();
                Heap heap = this.getContext().getFragment().getHeap();
                String viewID = this.getViewID();
                while (providers.hasNext()) {
                    if (providers.next().supportsView(heap, viewID)) continue;
                    providers.remove();
                }
            }
        }
        return this.valueProviders;
    }

    public static RootNode get(HeapViewerNode node) {
        while (node != null) {
            if (node instanceof RootNode) {
                return (RootNode)node;
            }
            node = node.getParent();
        }
        return null;
    }
}

