/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.type;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.type.ApplicationType;
import java.awt.Image;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class NetBeansApplicationType
extends ApplicationType {
    private static final String BUILD_NUMBER_PROPERTY = "netbeans.buildnumber";
    private static final String[] BUILD_NUMBERS = new String[]{"201006101454", "6.9", "201007282301", "6.9.1", "201104080000", "7.0", "201107282000", "7.0.1"};
    private static final String VERSION_REG = "\\d{1,2}\\.\\d{1,2}(\\.\\d{1,2})?";
    Application application;
    String name;
    Set<String> clusters;
    Jvm jvm;

    NetBeansApplicationType(Application app, Jvm vm, Set<String> cls) {
        this.application = app;
        this.jvm = vm;
        this.clusters = cls;
    }

    public Set<String> getClusters() {
        return this.clusters;
    }

    @Override
    public String getName() {
        return "NetBeans IDE " + this.getVersion();
    }

    @Override
    public String getVersion() {
        for (String cluster : this.getClusters()) {
            String ver;
            if (cluster.startsWith("nb") && (ver = cluster.substring("nb".length())).length() > 0 && Character.isDigit(ver.charAt(0))) {
                return ver;
            }
            if (!cluster.equals("nb")) continue;
            if (this.jvm.isGetSystemPropertiesSupported() && (ver = this.getVersionFromSysProps(this.jvm.getSystemProperties())) != null) {
                return ver;
            }
            return "6.9+";
        }
        return NbBundle.getMessage(NetBeansApplicationType.class, (String)"LBL_Unknown");
    }

    @Override
    public String getDescription() {
        String versionString;
        Properties sysProps;
        if (this.jvm.isGetSystemPropertiesSupported() && (sysProps = this.jvm.getSystemProperties()) != null && (versionString = sysProps.getProperty("netbeans.productversion")) != null) {
            return versionString;
        }
        return NbBundle.getMessage(NetBeansApplicationType.class, (String)"DESCR_NetBeansApplicationType");
    }

    @Override
    public Image getIcon() {
        String iconPath = "com/sun/tools/visualvm/application/type/resources/NetBeans.png";
        return ImageUtilities.loadImage((String)iconPath, (boolean)true);
    }

    private String getVersionFromSysProps(Properties properties) {
        if (properties == null) {
            return null;
        }
        String versionString = properties.getProperty("netbeans.productversion");
        if (versionString != null) {
            Scanner s = new Scanner(versionString);
            if ("NetBeans".equals(s.next()) && "IDE".equals(s.next())) {
                return s.next();
            }
            String ver = s.findInLine(VERSION_REG);
            if (ver != null) {
                return ver;
            }
        } else {
            String buildNumber = properties.getProperty(BUILD_NUMBER_PROPERTY);
            for (int i = 0; i < BUILD_NUMBERS.length; i += 2) {
                if (!BUILD_NUMBERS[i].equals(buildNumber)) continue;
                return BUILD_NUMBERS[i + 1];
            }
        }
        return null;
    }
}

