/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class AutomaticDependencies {
    private static final Logger LOG = Logger.getLogger(AutomaticDependencies.class.getName());
    private static AutomaticDependencies INSTANCE;
    private final List<TransformationGroup> groups = new ArrayList<TransformationGroup>();

    private AutomaticDependencies() {
    }

    public static AutomaticDependencies empty() {
        return new AutomaticDependencies();
    }

    public static AutomaticDependencies getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)"ModuleAutoDeps");
        if (fileObject != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<URL> arrayList = new ArrayList<URL>(Math.max(fileObjectArray.length, 1));
            for (FileObject fileObject2 : fileObjectArray) {
                if (!fileObject2.hasExt("xml")) continue;
                arrayList.add(fileObject2.toURL());
            }
            try {
                INSTANCE = AutomaticDependencies.parse(arrayList.toArray(new URL[arrayList.size()]));
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, null, iOException);
            }
            catch (SAXException sAXException) {
                Util.err.log(Level.WARNING, null, sAXException);
            }
        }
        if (INSTANCE == null) {
            INSTANCE = AutomaticDependencies.empty();
        }
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("Auto deps: " + INSTANCE);
        }
        return INSTANCE;
    }

    public static AutomaticDependencies parse(URL[] uRLArray) throws SAXException, IOException {
        LOG.log(Level.FINE, "Parsing automatic dependencies {0}", Arrays.asList(uRLArray));
        AutomaticDependencies automaticDependencies = new AutomaticDependencies();
        Parser parser = new Parser(automaticDependencies.new Handler());
        for (URL uRL : uRLArray) {
            String string = uRL.toExternalForm();
            try (InputStream inputStream = null;){
                InputSource inputSource = new InputSource(string);
                inputStream = new BufferedInputStream(uRL.openStream());
                inputSource.setByteStream(inputStream);
                parser.parse(inputSource);
            }
        }
        return automaticDependencies;
    }

    public static void main(String[] stringArray) throws Exception {
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = new URL(stringArray[i]);
        }
        AutomaticDependencies.parse(uRLArray);
        long l = System.currentTimeMillis();
        System.out.println(AutomaticDependencies.parse(uRLArray));
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Time taken: " + l2 + " msec");
    }

    public Report refineDependenciesAndReport(String string, Set<Dependency> set) {
        Object object;
        HashSet<Dependency> hashSet = new HashSet<Dependency>(set);
        HashMap<String, Dependency> hashMap = new HashMap<String, Dependency>();
        HashMap<String, Dependency> hashMap2 = new HashMap<String, Dependency>();
        HashMap<String, Dependency> hashMap3 = new HashMap<String, Dependency>();
        block6: for (Dependency object2 : set) {
            switch (object2.getType()) {
                case 1: {
                    String string2 = (String)Util.parseCodeName((String)object2.getName())[0];
                    hashMap.put(string2, object2);
                    continue block6;
                }
                case 2: {
                    object = AutomaticDependencies.packageBaseName(object2.getName());
                    hashMap3.put((String)object, object2);
                    continue block6;
                }
                case 5: 
                case 6: 
                case 7: {
                    hashMap2.put(object2.getName(), object2);
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
            throw new IllegalStateException(object2.toString());
        }
        TreeSet treeSet = new TreeSet();
        for (TransformationGroup transformationGroup : this.groups) {
            if (transformationGroup.isExcluded(string)) continue;
            object = new HashSet<Dependency>(set);
            for (Transformation transformation : transformationGroup.transformations) {
                transformation.apply(hashMap, hashMap2, hashMap3, set);
            }
            if (object.equals(set)) continue;
            treeSet.add(transformationGroup.description);
        }
        if (!hashSet.equals(set)) {
            assert (!treeSet.isEmpty());
            HashSet<Dependency> hashSet2 = new HashSet<Dependency>(set);
            hashSet2.removeAll(hashSet);
            hashSet.removeAll(set);
            return new Report(string, hashSet2, hashSet, treeSet);
        }
        assert (treeSet.isEmpty());
        return new Report(string, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public void refineDependencies(String string, Set<Dependency> set) {
        this.refineDependenciesAndReport(string, set);
    }

    public String refineDependenciesSimple(String string, Set<String> set) {
        HashSet<Dependency> hashSet = new HashSet<Dependency>();
        for (String object : set) {
            hashSet.addAll(Dependency.create((int)1, (String)object));
        }
        Report report = this.refineDependenciesAndReport(string, hashSet);
        if (report.isModified()) {
            set.clear();
            for (Dependency dependency : hashSet) {
                set.add(dependency.toString().replaceFirst("^module ", ""));
            }
            return report.toString();
        }
        return null;
    }

    public String toString() {
        return "AutomaticDependencies[" + this.groups + "]";
    }

    private static String packageBaseName(String string) {
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        int n2 = string.lastIndexOf(46);
        return string.substring(1, n2);
    }

    private static final class Parser
    implements ContentHandler,
    ErrorHandler,
    EntityResolver {
        private StringBuffer buffer;
        private Handler handler;
        private Stack<Object[]> context;

        public Parser(Handler handler) {
            this.handler = handler;
            this.buffer = new StringBuffer(111);
            this.context = new Stack();
        }

        @Override
        public final void setDocumentLocator(Locator locator) {
        }

        @Override
        public final void startDocument() throws SAXException {
        }

        @Override
        public final void endDocument() throws SAXException {
        }

        @Override
        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.dispatch(true);
            this.context.push(new Object[]{string3, new AttributesImpl(attributes)});
            if ("trigger-dependency".equals(string3)) {
                this.handler.start_trigger(attributes);
            } else if ("transformation".equals(string3)) {
                this.handler.start_transformation(attributes);
            } else if ("module-dependency".equals(string3)) {
                this.handler.handle_module_dependency(attributes);
            } else if ("transformationgroup".equals(string3)) {
                this.handler.start_transformationgroup(attributes);
            } else if ("result".equals(string3)) {
                this.handler.start_result(attributes);
            } else if ("exclusion".equals(string3)) {
                this.handler.handle_exclusion(attributes);
            } else if ("token-dependency".equals(string3)) {
                this.handler.handle_token_dependency(attributes);
            } else if ("package-dependency".equals(string3)) {
                this.handler.handle_package_dependency(attributes);
            } else if ("transformations".equals(string3)) {
                this.handler.start_transformations(attributes);
            } else if ("implies".equals(string3)) {
                this.handler.start_results(attributes);
            }
        }

        @Override
        public final void endElement(String string, String string2, String string3) throws SAXException {
            this.dispatch(false);
            this.context.pop();
            if ("trigger-dependency".equals(string3)) {
                this.handler.end_trigger();
            } else if ("transformation".equals(string3)) {
                this.handler.end_transformation();
            } else if ("transformationgroup".equals(string3)) {
                this.handler.end_transformationgroup();
            } else if ("result".equals(string3)) {
                this.handler.end_result();
            } else if ("transformations".equals(string3)) {
                this.handler.end_transformations();
            } else if ("implies".equals(string3)) {
                this.handler.end_results();
            }
        }

        @Override
        public final void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }

        @Override
        public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public final void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public final void startPrefixMapping(String string, String string2) throws SAXException {
        }

        @Override
        public final void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public final void skippedEntity(String string) throws SAXException {
        }

        private void dispatch(boolean bl) throws SAXException {
            if (bl && this.buffer.length() == 0) {
                return;
            }
            Object[] objectArray = this.context.peek();
            String string = (String)objectArray[0];
            Attributes attributes = (Attributes)objectArray[1];
            if ("description".equals(string)) {
                if (bl) {
                    throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
                }
                this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attributes);
            }
            this.buffer.delete(0, this.buffer.length());
        }

        public void parse(InputSource inputSource) throws SAXException, IOException {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setEntityResolver(this);
            xMLReader.parse(inputSource);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    private final class Handler {
        private TransformationGroup currentGroup = null;
        private Transformation currentTransformation = null;
        private boolean inTrigger = false;

        Handler() {
        }

        public void start_trigger(Attributes attributes) throws SAXException {
            this.inTrigger = true;
            this.currentTransformation.triggerType = attributes.getValue("type");
        }

        public void end_trigger() throws SAXException {
            this.inTrigger = false;
        }

        public void start_transformation(Attributes attributes) throws SAXException {
            this.currentTransformation = new Transformation();
        }

        public void end_transformation() throws SAXException {
            this.currentGroup.transformations.add(this.currentTransformation);
            this.currentTransformation = null;
        }

        private void handleDep(Dep dep) throws SAXException {
            if (this.inTrigger) {
                this.currentTransformation.trigger = dep;
            } else {
                this.currentTransformation.results.add(dep);
            }
        }

        public void handle_module_dependency(Attributes attributes) throws SAXException {
            ModuleDep moduleDep = new ModuleDep();
            String string = attributes.getValue("major");
            if (string != null) {
                moduleDep.major = Integer.parseInt(string);
            }
            moduleDep.codenamebase = attributes.getValue("codenamebase");
            String string2 = attributes.getValue("spec");
            moduleDep.spec = string2 == null ? null : new SpecificationVersion(string2);
            this.handleDep(moduleDep);
        }

        public void handle_token_dependency(Attributes attributes) throws SAXException {
            TokenDep tokenDep = new TokenDep();
            tokenDep.name = attributes.getValue("name");
            this.handleDep(tokenDep);
        }

        public void handle_package_dependency(Attributes attributes) throws SAXException {
            PackageDep packageDep = new PackageDep();
            packageDep.name = attributes.getValue("name");
            packageDep.bname = AutomaticDependencies.packageBaseName(packageDep.name);
            if (this.inTrigger && !packageDep.name.equals(packageDep.bname)) {
                throw new SAXException("Cannot use test class in trigger");
            }
            String string = attributes.getValue("spec");
            packageDep.spec = string == null ? null : new SpecificationVersion(string);
            this.handleDep(packageDep);
        }

        public void start_transformationgroup(Attributes attributes) throws SAXException {
            this.currentGroup = new TransformationGroup();
        }

        public void end_transformationgroup() throws SAXException {
            AutomaticDependencies.this.groups.add(this.currentGroup);
            this.currentGroup = null;
        }

        public void start_result(Attributes attributes) throws SAXException {
        }

        public void end_result() throws SAXException {
        }

        public void handle_exclusion(Attributes attributes) throws SAXException {
            Exclusion exclusion = new Exclusion();
            exclusion.codenamebase = attributes.getValue("codenamebase");
            exclusion.prefix = Boolean.valueOf(attributes.getValue("prefix"));
            this.currentGroup.exclusions.add(exclusion);
        }

        public void handle_description(String string, Attributes attributes) throws SAXException {
            this.currentGroup.description = string;
        }

        public void start_transformations(Attributes attributes) throws SAXException {
            if (!"1.0".equals(attributes.getValue("version"))) {
                throw new SAXException("Unsupported DTD");
            }
        }

        public void end_transformations() throws SAXException {
        }

        public void start_results(Attributes attributes) throws SAXException {
        }

        public void end_results() throws SAXException {
        }
    }

    private static final class TokenDep
    extends Dep {
        public String name;

        @Override
        public String toManifestForm() {
            return this.name;
        }

        @Override
        public String manifestKey() {
            return "OpenIDE-Module-Requires";
        }

        @Override
        public int type() {
            return 5;
        }

        @Override
        public Dependency applies(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set, String string) {
            Dependency dependency = map2.get(this.name);
            if (dependency == null) {
                return null;
            }
            if (string.equals("cancel")) {
                return dependency;
            }
            throw new IllegalStateException(string);
        }

        @Override
        public void update(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set) {
            if (map2.get(this.name) == null) {
                set.add(this.createDependency());
            }
        }
    }

    private static final class PackageDep
    extends Dep {
        public String name;
        public String bname;
        public SpecificationVersion spec = null;

        @Override
        public String toManifestForm() {
            return this.name + (this.spec == null ? "" : " > " + this.spec);
        }

        @Override
        public String manifestKey() {
            return "OpenIDE-Module-Package-Dependencies";
        }

        @Override
        public int type() {
            return 2;
        }

        private boolean older(Dependency dependency) {
            if (dependency.getType() != 2) {
                throw new IllegalArgumentException();
            }
            if (dependency.getComparison() == 2) {
                return false;
            }
            if (this.spec == null) {
                return false;
            }
            String string = dependency.getVersion();
            if (string == null) {
                return true;
            }
            assert (dependency.getComparison() == 1) : dependency.getComparison();
            return new SpecificationVersion(string).compareTo((Object)this.spec) < 0;
        }

        @Override
        public Dependency applies(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set, String string) {
            Dependency dependency = map3.get(this.bname);
            if (dependency == null) {
                return null;
            }
            if (string.equals("cancel")) {
                return dependency;
            }
            if (string.equals("older")) {
                if (this.spec == null) {
                    throw new IllegalStateException();
                }
                return this.older(dependency) ? dependency : null;
            }
            throw new IllegalStateException(string);
        }

        @Override
        public void update(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set) {
            Dependency dependency = map3.get(this.bname);
            if (dependency != null && this.older(dependency)) {
                set.remove(dependency);
                set.add(this.createDependency());
            } else if (dependency == null) {
                set.add(this.createDependency());
            }
        }
    }

    private static final class ModuleDep
    extends Dep {
        public String codenamebase;
        public int major = -1;
        public SpecificationVersion spec = null;

        @Override
        public String toManifestForm() {
            return this.codenamebase + (this.major == -1 ? "" : "/" + this.major) + (this.spec == null ? "" : " > " + this.spec);
        }

        @Override
        public String manifestKey() {
            return "OpenIDE-Module-Module-Dependencies";
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public Dependency applies(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set, String string) {
            Dependency dependency = map.get(this.codenamebase);
            if (dependency == null) {
                return null;
            }
            if (string.equals("cancel")) {
                return dependency;
            }
            if (string.equals("older")) {
                return this.older(dependency) ? dependency : null;
            }
            throw new IllegalArgumentException(string);
        }

        private boolean older(Dependency dependency) {
            int n;
            if (dependency.getType() != 1) {
                throw new IllegalArgumentException();
            }
            if (dependency.getComparison() == 2) {
                return false;
            }
            Integer n2 = (Integer)Util.parseCodeName((String)dependency.getName())[1];
            int n3 = n = n2 == null ? -1 : n2;
            if (n < this.major) {
                return true;
            }
            if (n > this.major) {
                return false;
            }
            if (this.spec == null) {
                return false;
            }
            String string = dependency.getVersion();
            if (string == null) {
                return true;
            }
            assert (dependency.getComparison() == 1) : dependency.getComparison();
            return new SpecificationVersion(string).compareTo((Object)this.spec) < 0;
        }

        @Override
        public void update(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set) {
            Dependency dependency = map.get(this.codenamebase);
            if (dependency != null && this.older(dependency)) {
                set.remove(dependency);
                Dependency dependency2 = this.createDependency();
                assert (!dependency2.equals((Object)dependency)) : "older() claimed to be true on itself for " + dependency;
                set.add(dependency2);
            } else if (dependency == null) {
                set.add(this.createDependency());
            }
        }
    }

    private static abstract class Dep {
        public final String toString() {
            return this.manifestKey() + ": " + this.toManifestForm();
        }

        public abstract String toManifestForm();

        public abstract String manifestKey();

        public abstract int type();

        public final Dependency createDependency() {
            return (Dependency)Dependency.create((int)this.type(), (String)this.toManifestForm()).iterator().next();
        }

        public abstract Dependency applies(Map<String, Dependency> var1, Map<String, Dependency> var2, Map<String, Dependency> var3, Set<Dependency> var4, String var5);

        public abstract void update(Map<String, Dependency> var1, Map<String, Dependency> var2, Map<String, Dependency> var3, Set<Dependency> var4);
    }

    private static final class Transformation {
        public Dep trigger;
        public String triggerType;
        public final List<Dep> results = new ArrayList<Dep>();

        public String toString() {
            return "Transformation[trigger=" + this.trigger + ",triggerType=" + this.triggerType + ",results=" + this.results + "]";
        }

        public void apply(Map<String, Dependency> map, Map<String, Dependency> map2, Map<String, Dependency> map3, Set<Dependency> set) {
            Dependency dependency = this.trigger.applies(map, map2, map3, set, this.triggerType);
            if (dependency != null) {
                if (this.triggerType.equals("cancel")) {
                    set.remove(dependency);
                } else if (!this.triggerType.equals("older")) {
                    throw new IllegalStateException(this.triggerType);
                }
                for (Dep dep : this.results) {
                    dep.update(map, map2, map3, set);
                }
            }
        }
    }

    private static final class TransformationGroup {
        public String description;
        public final List<Exclusion> exclusions = new ArrayList<Exclusion>();
        public final List<Transformation> transformations = new ArrayList<Transformation>();

        public String toString() {
            return "TransformationGroup[" + this.exclusions + "," + this.transformations + "]";
        }

        public boolean isExcluded(String string) {
            Iterator<Exclusion> iterator = this.exclusions.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().matches(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Exclusion {
        public String codenamebase;
        public boolean prefix;

        public String toString() {
            return "Exclusion[" + this.codenamebase + ",prefix=" + this.prefix + "]";
        }

        public boolean matches(String string) {
            return string.equals(this.codenamebase) || this.prefix && string.startsWith(this.codenamebase + ".");
        }
    }

    public static final class Report {
        private final String cnb;
        private final Set<Dependency> added;
        private final Set<Dependency> removed;
        private final Set<String> messages;

        Report(String string, Set<Dependency> set, Set<Dependency> set2, Set<String> set3) {
            this.cnb = string;
            this.added = set;
            this.removed = set2;
            this.messages = set3;
        }

        public Set<Dependency> getAdded() {
            return this.added;
        }

        public Set<Dependency> getRemoved() {
            return this.removed;
        }

        public Set<String> getMessages() {
            return this.messages;
        }

        public boolean isModified() {
            return !this.added.isEmpty() || !this.removed.isEmpty();
        }

        public String toString() {
            return "had to upgrade dependencies for module " + this.cnb + ": added = " + this.getAdded() + " removed = " + this.getRemoved() + "; details: " + this.getMessages();
        }
    }
}

