/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.logging.NbFormatter;
import org.netbeans.core.startup.logging.NbLogging;
import org.netbeans.core.startup.logging.PrintStreamLogger;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public final class TopLogging {
    private static boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private static final PrintStream OLD_ERR = System.err;
    private static File previousUser;
    private static Handler streamHandler;
    private static Handler defaultHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopLogging() {
        AWTHandler.install();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        LinkedList<Logger> linkedList = new LinkedList<Logger>();
        Properties properties = System.getProperties();
        for (String handlerArray2 : properties.stringPropertyNames()) {
            String i;
            if ("sun.os.patch.level".equals(handlerArray2) || (i = properties.getProperty(handlerArray2)) == null || !handlerArray2.endsWith(".level")) continue;
            printStream.print(handlerArray2);
            printStream.print('=');
            printStream.println(i);
            linkedList.add(Logger.getLogger(handlerArray2.substring(0, handlerArray2.length() - 6)));
        }
        printStream.close();
        try {
            StartLog.unregister();
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            StartLog.register();
        }
        Logger logger = Logger.getLogger("");
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            logger.removeHandler(handlerArray[i]);
        }
        logger.addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            logger.addHandler(TopLogging.streamHandler());
        }
        logger.addHandler(new LookupDel());
    }

    public static void initializeQuietly() {
        TopLogging.initialize(false);
    }

    public static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        NbFormatter.printStackTrace(throwable, printWriter);
    }

    static final void initialize() {
        TopLogging.initialize(true);
    }

    private static void initialize(boolean bl) {
        block15: {
            AWTHandler.install();
            if (previousUser == null || previousUser.equals(Places.getUserDirectory())) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                return;
            }
            String string = System.getProperty("java.util.logging.config.class");
            String string2 = TopLogging.class.getName();
            if (string != null && !string.equals(string2)) {
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", string2);
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                TopLogging.printSystemInfo(printStream);
                printStream.close();
                try {
                    Logger logger = Logger.getLogger(TopLogging.class.getName());
                    logger.log(Level.INFO, byteArrayOutputStream.toString("utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError();
                }
            }
        }
        if (!Boolean.getBoolean("netbeans.logger.noSystem")) {
            if (!PrintStreamLogger.isLogger(System.err)) {
                System.setErr(PrintStreamLogger.create("stderr"));
                if (NbLogging.DEBUG != null) {
                    NbLogging.DEBUG.println("initializing stderr");
                }
            }
            if (!PrintStreamLogger.isLogger(System.out)) {
                System.setErr(PrintStreamLogger.create("stderr"));
                if (NbLogging.DEBUG != null) {
                    NbLogging.DEBUG.println("initializing stdout");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemInfo(PrintStream printStream) {
        Object object;
        Object object222;
        Object object322;
        Object object4;
        Object object5;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        printStream.println("-------------------------------------------------------------------------------");
        printStream.println(">Log Session: " + dateFormat.format(date));
        printStream.println(">System Info: ");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            object5 = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object5).hasMoreTokens()) {
                object4 = FileUtil.normalizeFile((File)new File(((StringTokenizer)object5).nextToken()));
                if (!((File)object4).isDirectory()) continue;
                arrayList.add(object4);
            }
        }
        object5 = System.getProperty("netbeans.buildnumber");
        object4 = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)object5);
        System.setProperty("netbeans.productversion", (String)object4);
        printStream.print("  Product Version         = " + (String)object4);
        block6: for (Object object322 : arrayList) {
            object222 = new File((File)object322, "build_info");
            if (!((File)object222).isFile()) continue;
            try {
                object = new FileReader((File)object222);
                try {
                    String string2;
                    URL[] uRLArray = new BufferedReader((Reader)object);
                    Pattern pattern = Pattern.compile("Hg ID:    ([0-9a-f]{12})");
                    while ((string2 = uRLArray.readLine()) != null) {
                        Matcher object6 = pattern.matcher(string2);
                        if (!object6.matches()) continue;
                        printStream.print(" (#" + object6.group(1) + ")");
                        break block6;
                    }
                }
                finally {
                    ((Reader)object).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(printStream);
            }
            break;
        }
        printStream.println();
        printStream.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        printStream.println("  Java; VM; Vendor        = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        printStream.println("  Runtime                 = " + System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", ""));
        printStream.println("  Java Home               = " + System.getProperty("java.home", "unknown"));
        printStream.print("  System Locale; Encoding = " + Locale.getDefault());
        String string3 = NbBundle.getBranding();
        if (string3 != null) {
            printStream.print(" (" + (String)string3 + ")");
        }
        printStream.println("; " + System.getProperty("file.encoding", "unknown"));
        printStream.println("  Home Directory          = " + System.getProperty("user.home", "unknown"));
        printStream.println("  Current Directory       = " + System.getProperty("user.dir", "unknown"));
        printStream.print("  User Directory          = ");
        printStream.println(CLIOptions.getUserDir());
        printStream.println("  Cache Directory         = " + Places.getCacheDirectory());
        printStream.print("  Installation            = ");
        for (Object object222 : arrayList) {
            printStream.print(object222 + "\n                            ");
        }
        printStream.println(CLIOptions.getHomeDir());
        printStream.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        object222 = Lookup.class.getClassLoader();
        if (object222 == ClassLoader.getSystemClassLoader()) {
            object322 = System.getProperty("java.class.path", "unknown");
        } else {
            object = new StringBuilder("loaded by ");
            if (object222 instanceof URLClassLoader) {
                ((StringBuilder)object).append("URLClassLoader");
                for (URL uRL : ((URLClassLoader)object222).getURLs()) {
                    ((StringBuilder)object).append(' ').append(uRL);
                }
            } else {
                ((StringBuilder)object).append(object222);
            }
            object322 = ((StringBuilder)object).toString();
        }
        printStream.println("  Application Classpath   = " + (String)object322);
        printStream.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        printStream.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String string = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer = string != null ? new StringBuffer(string) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), stringBuffer);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), stringBuffer);
        return stringBuffer.toString();
    }

    private static void findBootJars(String string, StringBuffer stringBuffer) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(fileArray[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream printStream) {
        StreamHandler streamHandler = new StreamHandler(printStream, NbFormatter.FORMATTER);
        return NbLogging.createDispatchHandler(streamHandler, 50);
    }

    private static synchronized Handler streamHandler() {
        if (streamHandler == null) {
            StreamHandler streamHandler = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            streamHandler.setLevel(Level.ALL);
            TopLogging.streamHandler = NbLogging.createDispatchHandler(streamHandler, 500);
        }
        return streamHandler;
    }

    private static synchronized Handler defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        File file = Places.getUserDirectory();
        if (file != null && !CLIOptions.noLogging) {
            File file2 = new File(new File(file, "var"), "log");
            file2.mkdirs();
            Handler handler = NbLogging.createMessagesHandler(file2);
            defaultHandler = NbLogging.createDispatchHandler(handler, 5000);
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean bl) {
        Handler handler;
        System.err.flush();
        Handler handler2 = streamHandler;
        if (handler2 != null) {
            handler2.flush();
        }
        if ((handler = defaultHandler) != null) {
            handler.flush();
        }
        if (bl) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        NbLogging.close(streamHandler);
        NbLogging.close(defaultHandler);
    }

    static void exit(int n) {
        TopLogging.flush(false);
        TopSecurityManager.exit((int)n);
    }

    private static final class AWTHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler delegate;
        private final Logger g;

        private AWTHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.delegate = uncaughtExceptionHandler;
            this.g = Logger.getLogger("global");
        }

        static void install() {
            if (Thread.getDefaultUncaughtExceptionHandler() instanceof AWTHandler) {
                return;
            }
            Thread.setDefaultUncaughtExceptionHandler(new AWTHandler(Thread.getDefaultUncaughtExceptionHandler()));
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (this.delegate != null) {
                this.delegate.uncaughtException(thread, throwable);
            }
            if (throwable.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            if (throwable instanceof ThreadDeath) {
                return;
            }
            this.g.log(Level.SEVERE, null, throwable);
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.instances.size();
            this.handlers.addLookupListener((LookupListener)this);
        }

        @Override
        public void publish(LogRecord logRecord) {
            for (Handler handler : this.instances) {
                handler.publish(logRecord);
            }
        }

        @Override
        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        @Override
        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.instances = this.handlers.allInstances();
        }
    }
}

