/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.core.multiview.Bundle;
import org.netbeans.core.multiview.Splitable;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SplitAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    boolean useSplitName = false;

    public SplitAction() {
        super(Bundle.CTL_SplitDocumentAction());
    }

    public SplitAction(boolean bl) {
        super(Bundle.CTL_SplitDocumentAction());
        this.useSplitName = bl;
    }

    static Action createSplitAction(Map map) {
        if (!SplitAction.isSplitingEnabled()) {
            return null;
        }
        Object v = map.get("displayName");
        if (v == null) {
            return null;
        }
        return new SplitAction(v.toString().equals(Bundle.CTL_SplitAction()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public JMenuItem getMenuPresenter() {
        return this.getSplitMenuItem();
    }

    public JMenuItem getPopupPresenter() {
        return this.getSplitMenuItem();
    }

    private JMenuItem getSplitMenuItem() {
        if (!SplitAction.isSplitingEnabled()) {
            return null;
        }
        UpdatingMenu updatingMenu = new UpdatingMenu();
        String string = this.useSplitName ? Bundle.CTL_SplitAction() : Bundle.CTL_SplitDocumentAction();
        Mnemonics.setLocalizedText((AbstractButton)updatingMenu, (String)string);
        return updatingMenu;
    }

    static boolean isSplitingEnabled() {
        boolean bl = "true".equals(Bundle.MultiViewElement_Spliting_Enabled());
        return bl;
    }

    static void splitWindow(TopComponent topComponent, int n) {
        SplitAction.splitWindow(topComponent, n, -1);
    }

    static void splitWindow(TopComponent topComponent, int n, int n2) {
        if (topComponent instanceof Splitable) {
            TopComponent topComponent2 = ((Splitable)topComponent).splitComponent(n, n2);
            topComponent2.open();
            topComponent2.requestActive();
            topComponent2.invalidate();
            topComponent2.revalidate();
            topComponent2.repaint();
            topComponent2.requestFocusInWindow();
        }
    }

    static void clearSplit(TopComponent topComponent, int n) {
        if (topComponent instanceof Splitable) {
            TopComponent topComponent2 = ((Splitable)topComponent).clearSplit(n);
            topComponent2.open();
            topComponent2.requestActive();
            topComponent2.invalidate();
            topComponent2.revalidate();
            topComponent2.repaint();
            topComponent2.requestFocusInWindow();
        }
    }

    private static class ClearSplitAction
    extends AbstractAction {
        private final Reference<TopComponent> tcRef;

        public ClearSplitAction(TopComponent topComponent) {
            this.tcRef = new WeakReference<TopComponent>(topComponent);
            this.putValue("Name", Bundle.LBL_ClearSplitAction());
            this.putValue("_nb_action_id_", Bundle.LBL_ValueClearSplit());
            if (topComponent instanceof Splitable) {
                this.setEnabled(((Splitable)topComponent).getSplitOrientation() != -1);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopComponent topComponent = this.tcRef.get();
            if (topComponent != null) {
                SplitAction.clearSplit(topComponent, -1);
            }
        }
    }

    private static class SplitDocumentAction
    extends AbstractAction {
        private final Reference<TopComponent> tcRef;
        private final int orientation;

        public SplitDocumentAction(TopComponent topComponent, int n) {
            this.tcRef = new WeakReference<TopComponent>(topComponent);
            this.orientation = n;
            this.putValue("Name", n == 0 ? Bundle.LBL_SplitDocumentActionVertical() : Bundle.LBL_SplitDocumentActionHorizontal());
            this.putValue("_nb_action_id_", n == 0 ? Bundle.LBL_ValueSplitVertical() : Bundle.LBL_ValueSplitHorizontal());
            if (topComponent instanceof Splitable) {
                int n2 = ((Splitable)topComponent).getSplitOrientation();
                this.setEnabled(n2 == -1 || n2 != n);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopComponent topComponent = this.tcRef.get();
            if (topComponent != null) {
                SplitAction.splitWindow(topComponent, this.orientation);
            }
        }
    }

    private static final class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private UpdatingMenu() {
        }

        public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
            return this.getMenuPresenters();
        }

        public JComponent[] getMenuPresenters() {
            assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT";
            this.removeAll();
            TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
            if (topComponent != null) {
                this.setEnabled(true);
                if (topComponent instanceof Splitable && ((Splitable)topComponent).canSplit()) {
                    JMenuItem jMenuItem = new JMenuItem(new SplitDocumentAction(topComponent, 0));
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                    jMenuItem = new JMenuItem(new SplitDocumentAction(topComponent, 1));
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                    jMenuItem = new JMenuItem(new ClearSplitAction(topComponent));
                    Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)jMenuItem.getText());
                    this.add(jMenuItem);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }
    }
}

