/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import org.netbeans.lib.profiler.ui.UIUtils;

public class CustomTaskButtonBorder
extends AbstractBorder {
    public static final int BORDER_STATE_DEFAULT = 10;
    public static final int BORDER_STATE_FOCUSED = 20;
    public static final int BORDER_STATE_SELECTED = 30;
    private static final Color OUTLINE_CLR = new Color(0, 0, 0);
    private static final Color FOCUSED_TOP_LIGHT_CLR = new Color(206, 231, 255);
    private static final Color FOCUSED_TOP_DARK_CLR = new Color(188, 212, 246);
    private static final Color FOCUSED_BOTTOM_LIGHT_CLR = new Color(137, 173, 228);
    private static final Color FOCUSED_BOTTOM_DARK_CLR = new Color(105, 130, 238);
    private static final Color SELECTED_TOP_LIGHT_CLR = new Color(255, 240, 207);
    private static final Color SELECTED_TOP_DARK_CLR = new Color(253, 216, 137);
    private static final Color SELECTED_BOTTOM_LIGHT_CLR = new Color(248, 178, 48);
    private static final Color SELECTED_BOTTOM_DARK_CLR = new Color(229, 151, 0);
    private Color DEFAULT_BOTTOM_DARK_CLR;
    private Color DEFAULT_BOTTOM_LIGHT_CLR;
    private Color DEFAULT_TOP_DARK_CLR;
    private Color DEFAULT_TOP_LIGHT_CLR;
    private Color backgroundColor;
    private Color backgroundFade;
    private Color startColor;
    private Color stopColor;
    private int borderState;

    public CustomTaskButtonBorder(Color color, Color color2) {
        this.setForegroundColor(color);
        this.setBackgroundColor(color2);
        this.setDefault();
    }

    public CustomTaskButtonBorder(Color color, Color color2, int n) {
        this(color, color2);
        this.setBorderState(n);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.backgroundFade = UIUtils.getSafeColor((3 * color.getRed() + 1 * OUTLINE_CLR.getRed()) / 4, (3 * color.getGreen() + 1 * OUTLINE_CLR.getGreen()) / 4, (3 * color.getBlue() + 1 * OUTLINE_CLR.getBlue()) / 4);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public static Insets getBorderInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public static CustomTaskButtonBorder getDefaultInstance(Color color, Color color2) {
        return new CustomTaskButtonBorder(color, color2, 10);
    }

    public static CustomTaskButtonBorder getFocusedInstance(Color color, Color color2) {
        return new CustomTaskButtonBorder(color, color2, 20);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return CustomTaskButtonBorder.getBorderInsets();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void setBorderState(int n) {
        this.borderState = n;
    }

    public int getBorderState() {
        return this.borderState;
    }

    public void setFocused() {
        this.setBorderState(20);
    }

    public void setForegroundColor(Color color) {
        this.DEFAULT_TOP_LIGHT_CLR = UIUtils.getSafeColor(color.getRed() + 15, color.getGreen() + 15, color.getBlue() + 15);
        this.DEFAULT_TOP_DARK_CLR = UIUtils.getSafeColor(color.getRed() + 8, color.getGreen() + 8, color.getBlue() + 8);
        this.DEFAULT_BOTTOM_LIGHT_CLR = UIUtils.getSafeColor(color.getRed() - 11, color.getGreen() - 11, color.getBlue() - 11);
        this.DEFAULT_BOTTOM_DARK_CLR = UIUtils.getSafeColor(color.getRed() - 25, color.getGreen() - 25, color.getBlue() - 25);
    }

    public Color getForegroundColor() {
        return UIUtils.getSafeColor(this.DEFAULT_TOP_LIGHT_CLR.getRed() - 15, this.DEFAULT_TOP_LIGHT_CLR.getGreen() - 15, this.DEFAULT_TOP_LIGHT_CLR.getBlue() - 15);
    }

    public static CustomTaskButtonBorder getSelectedInstance(Color color, Color color2) {
        return new CustomTaskButtonBorder(color, color2, 30);
    }

    public void setDefault() {
        this.setBorderState(10);
    }

    public void setSelected() {
        this.setBorderState(30);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.backgroundColor);
        graphics2D.drawLine(n, n2, n, n2);
        graphics2D.drawLine(n, n2 + n4 - 1, n, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2);
        graphics2D.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics2D.setColor(this.backgroundFade);
        graphics2D.drawLine(n + 1, n2, n + 1, n2);
        graphics2D.drawLine(n, n2 + 1, n, n2 + 1);
        graphics2D.drawLine(n + 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
        graphics2D.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
        graphics2D.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 1);
        graphics2D.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
        graphics2D.drawLine(n + n3 - 2, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        graphics2D.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
        graphics2D.setColor(OUTLINE_CLR);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics2D.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + 1);
        graphics2D.drawLine(n + 1, n2 + n4 - 2, n + 1, n2 + n4 - 2);
        graphics2D.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
        graphics2D.setColor(OUTLINE_CLR);
        graphics2D.drawLine(n + 2, n2, n + n3 - 3, n2);
        graphics2D.drawLine(n, n2 + 2, n, n2 + n4 - 3);
        graphics2D.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 3);
        graphics2D.drawLine(n + 2, n2 + n4 - 1, n + n3 - 3, n2 + n4 - 1);
        switch (this.borderState) {
            case 10: {
                graphics2D.setColor(this.DEFAULT_TOP_LIGHT_CLR);
                break;
            }
            case 20: {
                graphics2D.setColor(FOCUSED_TOP_LIGHT_CLR);
                break;
            }
            case 30: {
                graphics2D.setColor(SELECTED_TOP_LIGHT_CLR);
            }
        }
        graphics.drawLine(n + 2, n2 + 1, n + n3 - 3, n2 + 1);
        switch (this.borderState) {
            case 10: {
                graphics2D.setColor(this.DEFAULT_TOP_DARK_CLR);
                break;
            }
            case 20: {
                graphics2D.setColor(FOCUSED_TOP_DARK_CLR);
                break;
            }
            case 30: {
                graphics2D.setColor(SELECTED_TOP_DARK_CLR);
            }
        }
        graphics2D.drawLine(n + 1, n2 + 2, n + n3 - 2, n2 + 2);
        graphics2D.drawLine(n + 1, n2 + 3, n + n3 - 2, n2 + 3);
        switch (this.borderState) {
            case 10: {
                graphics2D.setColor(this.DEFAULT_BOTTOM_LIGHT_CLR);
                break;
            }
            case 20: {
                graphics2D.setColor(FOCUSED_BOTTOM_LIGHT_CLR);
                break;
            }
            case 30: {
                graphics2D.setColor(SELECTED_BOTTOM_LIGHT_CLR);
            }
        }
        graphics2D.drawLine(n + 1, n2 + n4 - 4, n + n3 - 2, n2 + n4 - 4);
        graphics2D.drawLine(n + 1, n2 + n4 - 3, n + n3 - 2, n2 + n4 - 3);
        switch (this.borderState) {
            case 10: {
                graphics2D.setColor(this.DEFAULT_BOTTOM_DARK_CLR);
                break;
            }
            case 20: {
                graphics2D.setColor(FOCUSED_BOTTOM_DARK_CLR);
                break;
            }
            case 30: {
                graphics2D.setColor(SELECTED_BOTTOM_DARK_CLR);
            }
        }
        graphics2D.drawLine(n + 2, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
        switch (this.borderState) {
            case 10: {
                this.startColor = this.DEFAULT_TOP_DARK_CLR;
                this.stopColor = this.DEFAULT_BOTTOM_LIGHT_CLR;
                break;
            }
            case 20: {
                this.startColor = FOCUSED_TOP_DARK_CLR;
                this.stopColor = FOCUSED_BOTTOM_LIGHT_CLR;
                break;
            }
            case 30: {
                this.startColor = SELECTED_TOP_DARK_CLR;
                this.stopColor = SELECTED_BOTTOM_LIGHT_CLR;
            }
        }
        graphics2D.setPaint(new GradientPaint(n + 1, n2 + 3, this.startColor, n + 1, n2 + n4 - 5, this.stopColor));
        graphics2D.fillRect(n + 1, n2 + 3, 3, n4 - 7);
        graphics2D.fillRect(n + n3 - 4, n2 + 3, 3, n4 - 7);
    }
}

